<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Atributo extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("categoria_model");
    $this->load->model("laboratorio_model");
    $this->load->model("pactivo_model");
    $this->load->model("aterapeutica_model");
    $this->load->model("ubicacion_model");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->categoria_model->mostrarTotal();
    $this->layout->setTitle("Categoria");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas"));
  }

  public function categoriai($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array('descripcion' =>$this->input->post('descripcion',true));
        $guardar=$this->categoria_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $consulta=$this->categoria_model->contador($this->input->post('descripcion',true));
        if ($consulta==0) {
          $data=array('descripcion'=>$this->input->post('descripcion',true));
          $insertar=$this->categoria_model->insert($data);
          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'La categoria ya EXISTE!!!!!!');
        }
      }
      echo base_url()."atributo";
      exit();
    }

    $datos=$id!=null?$this->categoria_model->mostrar($id):(object) array("descripcion"=>'');
    $this->layout->setLayout("blanco");
    $this->layout->view("atributoi",compact('datos'));
  }

  public function categoriad($id)
  {
    if (!$id) {show_404();}
    $datos=$this->categoria_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    $contador=$this->producto_model->contador(array("idcategoria"=>$id));
    if ($contador>0) {
      echo 'no borrado';
    }else{
      $eliminar=$this->categoria_model->delete($id);
      echo 'borrado';
    }
  }

  public function laboratorio()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->laboratorio_model->mostrarTotal();
    $this->layout->setTitle("Laboratorio");
    $this->layout->view("laboratorio",compact("establecimientos","nestablecimiento","listas"));
  }

  public function laboratorioi($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array('descripcion'=>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')));
        $guardar=$this->laboratorio_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $consulta=$this->laboratorio_model->contador($this->input->post('descripcion',true));
        if ($consulta==0) {
          $data=array('descripcion'=>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')));
          $insertar=$this->laboratorio_model->insert($data);
          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'El laboratorio ya EXISTE!!!!!!');
        }
      }
      echo base_url()."atributo/laboratorio";
      exit();
    }

    $datos=$id!=null?$this->laboratorio_model->mostrar($id):(object) array("descripcion"=>'');
    $this->layout->setLayout("blanco");
    $this->layout->view("atributoi",compact('datos'));
  }

  public function laboratoriod($id)
  {
    if (!$id) {show_404();}
    $datos=$this->laboratorio_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    echo $contador=$this->producto_model->contador(array("idlaboratorio"=>$id));
    if ($contador>0) {
      echo 'no borrado';
    }else{
      $eliminar=$this->laboratorio_model->delete($id);
      echo 'borrado';
    }
  }

  public function pactivo()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->pactivo_model->mostrarTotal();
    $this->layout->setTitle("Principio Activo");
    $this->layout->view("pactivo",compact("establecimientos","nestablecimiento","listas"));
  }

  public function pactivoi($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array('descripcion'=>$this->input->post('descripcion',true));
        $guardar=$this->pactivo_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $consulta=$this->pactivo_model->contador($this->input->post('descripcion',true));
        if ($consulta==0) {
          $data=array('descripcion'=>$this->input->post('descripcion',true));
          $insertar=$this->pactivo_model->insert($data);
          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'El principo activo ya EXISTE!!!!!!');
        }
      }
      echo base_url()."atributo/pactivo";
      exit();
    }

    $datos=$id!=null?$this->pactivo_model->mostrar($id):(object) array("descripcion"=>'');
    $this->layout->setLayout("blanco");
    $this->layout->view("atributoi",compact('datos'));
  }

  public function pactivod($id)
  {
    if (!$id) {show_404();}
    $datos=$this->pactivo_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    $contador=$this->producto_model->contador(array("idpactivo"=>$id));
    if ($contador>0) {
      echo 'no borrado';
    }else{
      $eliminar=$this->pactivo_model->delete($id);
      echo 'borrado';
    }
  }

  public function aterapeutica()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->aterapeutica_model->mostrarTotal();
    $this->layout->setTitle("Accion Terapeutica");
    $this->layout->view("aterapeutica",compact("establecimientos","nestablecimiento","listas"));
  }

  public function aterapeuticai($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array('descripcion'=>$this->input->post('descripcion',true));
        $guardar=$this->aterapeutica_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $consulta=$this->aterapeutica_model->contador($this->input->post('descripcion',true));
        if ($consulta==0) {
          $data=array('descripcion'=>$this->input->post('descripcion',true));
          $insertar=$this->aterapeutica_model->insert($data);
          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'La accion terapeutica ya EXISTE!!!!!!');
        }
      }
      echo base_url()."atributo/aterapeutica";
      exit();
    }

    $datos=$id!=null?$this->aterapeutica_model->mostrar($id):(object) array("descripcion"=>'');
    $this->layout->setLayout("blanco");
    $this->layout->view("atributoi",compact('datos'));
  }

  public function aterapeuticad($id)
  {
    if (!$id) {show_404();}
    $datos=$this->aterapeutica_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    $contador=$this->producto_model->contador(array("idaterapeutica"=>$id));
    if ($contador>0) {
      echo 'no borrado';
    }else{
      $eliminar=$this->aterapeutica_model->delete($id);
      echo 'borrado';
    }
  }

  public function ubicacion()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->ubicacion_model->mostrarTotal();
    $this->layout->setTitle("Ubicacion");
    $this->layout->view("ubicacion",compact("establecimientos","nestablecimiento","listas"));
  }

  public function ubicacioni($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array('descripcion'=>$this->input->post('descripcion',true));
        $guardar=$this->ubicacion_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $consulta=$this->ubicacion_model->contador($this->input->post('descripcion',true));
        if ($consulta==0) {
          $data=array('descripcion'=>$this->input->post('descripcion',true));
          $insertar=$this->ubicacion_model->insert($data);
          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'La accion terapeutica ya EXISTE!!!!!!');
        }
      }
      echo base_url()."atributo/ubicacion";
      exit();
    }

    $datos=$id!=null?$this->ubicacion_model->mostrar($id):(object) array("descripcion"=>'');
    $this->layout->setLayout("blanco");
    $this->layout->view("atributoi",compact('datos'));
  }

  public function ubicaciond($id)
  {
    if (!$id) {show_404();}
    $datos=$this->ubicacion_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    $contador=$this->producto_model->contador(array("idubicacion"=>$id));
    if ($contador>0) {
      echo 'no borrado';
    }else{
      $eliminar=$this->ubicacion_model->delete($id);
      echo 'borrado';
    }
  }


}
