<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Caja extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("tpago_model");
    $this->load->model("compra_model");
		$this->load->model("pago_model");
    $this->load->model("nventa_model");
    $this->load->model("venta_model");
		$this->load->model("cobro_model");
		$this->load->model("cobroe_model");
    $this->load->model("nota_model");
		$this->load->model("cobron_model");
		$this->load->model("ingreso_model");
		$this->load->model("gasto_model");
		$this->load->model("arqueo_model");
		$this->load->model("arqueod_model");
		$this->load->library("mytcpdf");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
    $empresa=$this->empresa_model->mostrar();

		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-7 day',date("Y-m-d")) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->arqueo_model->mostrarTotal($filtros);
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		$this->layout->setTitle("Arqueo Caja");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","empresa","listas","inicio","fin","arqueoc"));
	}

	public function arqueoi()
	{
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		if ($arqueoc>0) {redirect(base_url().'caja');}

		if ($this->input->post())
		{
			$data=array
			(
				"idestablecimiento"	=>$this->session->userdata("predeterminado"),
				'iduser'						=>$this->session->userdata('id'),
				'femision'					=>date("Y-m-d"),
				'finicial'					=>date("Y-m-d H:i:s"),
				'minicial'					=>$this->input->post('minicial',true),
				'estado'						=>1,
			);
			$insertar=$this->arqueo_model->insert($data);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");

			redirect(base_url().'caja');
		}

		$this->layout->setTitle("Arqueo Caja");
		$this->layout->view("arqueoi");
	}

	public function arqueoc($id)
	{
		$datos=$this->arqueo_model->mostrar($id);
		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"idtpago"=>1,"idarqueoc"=>NULL,"iduser"=>$datos->iduser);
		//cobros comprobante
		$mcobrosc=$this->cobroe_model->montoTotal($filtros);
		$mcobrosn=$this->cobron_model->montoTotal($filtros);
		$totalComprobante=$mcobrosc->total+$mcobrosn->total;

		//cobros
		$mcobros=$this->cobro_model->montoTotal($filtros);
		$totalNventas=$mcobros->total;

		//ingresos
		$mingresos=$this->ingreso_model->montoTotal($filtros);
		$totalIngresos=$mingresos->total;

		//pagos
		$mpagos=$this->pago_model->montoTotal($filtros);
		$totalCompras=$mpagos->total;

		//gastos
		$mgastos=$this->gasto_model->montoTotal($filtros);
		$totalGastos=$mgastos->total;

		$saldo=$datos->minicial+$totalComprobante+$totalNventas+$totalIngresos-$totalCompras-$totalGastos;
		$data=array
		(
			'ffinal'		=>date("Y-m-d H:i:s"),
			'ventas'		=>$totalComprobante+$totalNventas,
			'compras'		=>$totalCompras,
			'ingresos'	=>$totalIngresos,
			'gastos'		=>$totalGastos,
			'mfinal'		=>$saldo,
			'estado'		=>0,
		);
		$actualizar=$this->arqueo_model->update($data,$id);

		$filtrosm=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"idarqueoc"=>NULL,"iduser"=>$datos->iduser);
		$medios=$this->cobro_model->mediosPagos($filtrosm);
		foreach ($medios as $medio) {
			$filtron=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"idarqueoc"=>NULL,"iduser"=>$datos->iduser,"idtpago"=>$medio->idtpago);
			$notas=$this->cobron_model->montoTotal($filtron);
			$datad=array
			(
				'idarqueo'=>$id,
				'idtpago'		=>$medio->idtpago,
				'importe'	=>$medio->total+$notas->total,
			);
			$insertard=$this->arqueod_model->insert($datad);
		}

		$datac=array("idarqueoc"=>$id);
		$actualiza=$this->cobro_model->update($datac,$filtrosm);
		$actualizac=$this->cobroe_model->update($datac,$filtrosm);
		$actualizan=$this->cobron_model->update($datac,$filtrosm);
		$actualizap=$this->pago_model->update($datac,$filtros);
		$actualizai=$this->ingreso_model->update($datac,$filtros);
		$actualizag=$this->gasto_model->update($datac,$filtros);

		$this->session->set_flashdata("css", "success");
		$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
		redirect(base_url()."caja");
	}

	public function cerrar($id)
	{
		if ($this->input->post())
		{
			$datos=$this->arqueo_model->mostrar($id);
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"idtpago"=>1,"idarqueoc"=>NULL,"iduser"=>$datos->iduser);
			//cobros comprobante
			$mcobrosc=$this->cobroe_model->montoTotal($filtros);
			$mcobrosn=$this->cobron_model->montoTotal($filtros);
			$totalComprobante=$mcobrosc->total+$mcobrosn->total;

			//cobros
			$mcobros=$this->cobro_model->montoTotal($filtros);
			$totalNventas=$mcobros->total;

			//ingresos
			$mingresos=$this->ingreso_model->montoTotal($filtros);
			$totalIngresos=$mingresos->total;

			//pagos
			$mpagos=$this->pago_model->montoTotal($filtros);
			$totalCompras=$mpagos->total;

			//gastos
			$mgastos=$this->gasto_model->montoTotal($filtros);
			$totalGastos=$mgastos->total;

			$saldo=$datos->minicial+$totalComprobante+$totalNventas+$totalIngresos-$totalCompras-$totalGastos;
			$data=array
			(
				'ffinal'		=>date("Y-m-d H:i:s"),
				'ventas'		=>$totalComprobante+$totalNventas,
				'compras'		=>$totalCompras,
				'ingresos'	=>$totalIngresos,
				'gastos'		=>$totalGastos,
				'mfinal'		=>$this->input->post('mfinal',true),
				'estado'		=>0,
			);
			$actualizar=$this->arqueo_model->update($data,$id);

			$filtrosm=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"idarqueoc"=>NULL,"iduser"=>$datos->iduser);
			$medios=$this->cobro_model->mediosPagos($filtrosm);
			foreach ($medios as $medio) {
				$filtron=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"idarqueoc"=>NULL,"iduser"=>$datos->iduser,"idtpago"=>$medio->idtpago);
				$notas=$this->cobron_model->montoTotal($filtron);
				$datad=array
				(
					'idarqueo'=>$id,
					'idtpago'		=>$medio->idtpago,
					'importe'	=>$medio->total+$notas->total,
				);
				$insertard=$this->arqueod_model->insert($datad);
			}

			$datac=array("idarqueoc"=>$id);
			$actualiza=$this->cobro_model->update($datac,$filtrosm);
			$actualizac=$this->cobroe_model->update($datac,$filtrosm);
			$actualizan=$this->cobron_model->update($datac,$filtrosm);
			$actualizap=$this->pago_model->update($datac,$filtros);
			$actualizai=$this->ingreso_model->update($datac,$filtros);
			$actualizag=$this->gasto_model->update($datac,$filtros);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
			echo base_url()."caja";
			exit();
		}

		$this->layout->setLayout("blanco");
		$this->layout->view("arqueoc");
	}

	public function opciones($id)
	{
		$this->layout->setLayout("blanco");
		$this->layout->view("opciones",compact("id"));
	}

	public function pdfa4($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->arqueo_model->mostrar($id);
		$detalles=$this->arqueod_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);

		$cobros=$this->cobro_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrose=$this->cobroe_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrosn=$this->cobron_model->mostrarTotal(array("idarqueoc"=>$id));
		$ingresos=$this->ingreso_model->mostrarTotal(array("idarqueoc"=>$id));
		$pagos=$this->pago_model->mostrarTotal(array("idarqueoc"=>$id));
		$gastos=$this->gasto_model->mostrarTotal(array("idarqueoc"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa4",compact("empresa","nestablecimiento","datos","detalles","nombre","id","cobros","cobrose","cobrosn","ingresos","pagos","gastos"));
	}

	public function pdf80($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->arqueo_model->mostrar($id);
		$detalles=$this->arqueod_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);

		$cobros=$this->cobro_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrose=$this->cobroe_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrosn=$this->cobron_model->mostrarTotal(array("idarqueoc"=>$id));
		$ingresos=$this->ingreso_model->mostrarTotal(array("idarqueoc"=>$id));
		$pagos=$this->pago_model->mostrarTotal(array("idarqueoc"=>$id));
		$gastos=$this->gasto_model->mostrarTotal(array("idarqueoc"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf80",compact("empresa","nestablecimiento","datos","detalles","nombre","id","cobros","cobrose","cobrosn","ingresos","pagos","gastos"));
	}

	public function pdf58($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->arqueo_model->mostrar($id);
		$detalles=$this->arqueod_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);

		$cobros=$this->cobro_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrose=$this->cobroe_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrosn=$this->cobron_model->mostrarTotal(array("idarqueoc"=>$id));
		$ingresos=$this->ingreso_model->mostrarTotal(array("idarqueoc"=>$id));
		$pagos=$this->pago_model->mostrarTotal(array("idarqueoc"=>$id));
		$gastos=$this->gasto_model->mostrarTotal(array("idarqueoc"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf58",compact("empresa","nestablecimiento","datos","detalles","nombre","id","cobros","cobrose","cobrosn","ingresos","pagos","gastos"));
	}

	public function pdfa5($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->arqueo_model->mostrar($id);
		$detalles=$this->arqueod_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);

		$cobros=$this->cobro_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrose=$this->cobroe_model->mostrarTotal(array("idarqueoc"=>$id));
		$cobrosn=$this->cobron_model->mostrarTotal(array("idarqueoc"=>$id));
		$ingresos=$this->ingreso_model->mostrarTotal(array("idarqueoc"=>$id));
		$pagos=$this->pago_model->mostrarTotal(array("idarqueoc"=>$id));
		$gastos=$this->gasto_model->mostrarTotal(array("idarqueoc"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa5",compact("empresa","nestablecimiento","datos","detalles","nombre","id","cobros","cobrose","cobrosn","ingresos","pagos","gastos"));
	}

	public function mpago()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : date("Y-m-d") ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;

		$medios=$this->tpago_model->mostrarTotal();
		$this->layout->setTitle("Medio Pago");
		$this->layout->view("mpago",compact("establecimientos","nestablecimiento","empresa","inicio","fin","medios"));
	}

	public function pdfcaja($inicio,$fin)
  {
  	$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
    $medios=$this->tpago_model->mostrarTotal();
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfcaja",compact("empresa","nestablecimiento","medios","inicio","fin"));
  }



}
