<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Cobrar extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("tpago_model");
    $this->load->model("nventa_model");
    $this->load->model("venta_model");
    $this->load->model("cobro_model");
    $this->load->model("cobroe_model");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"cancelado"=>0);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,"cancelado"=>0);}
    $listas=$this->nventa_model->mostrarTotal($filtros,"desc");
    $listasc=$this->venta_model->mostrarTotal($filtros,"desc");
    $this->layout->setTitle("Cuenta por cobrar");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas","listasc"));
  }

  public function cobrari($id)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->input->post())
    {
      if ($this->input->post('importe',true)>$this->input->post('saldo',true)) {
        $this->session->set_flashdata("css", "danger");
        $this->session->set_flashdata("mensaje", "El monto es mucho mayor al que tiene que cobrar");
      } else {
        $data=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          'iduser'            =>$this->session->userdata('id'),
          'idnventa'          =>$id,
          'femision'          =>date("Y-m-d"),
          'total'             =>$this->input->post('importe',true),
          'idtpago'           =>$this->input->post('mpago',true),
        );
        $insertar=$this->cobro_model->insert($data);

        $cobros=$this->cobro_model->montoTotal(array("nulo"=>0,"idnventa"=>$id));
        $saldo=$this->input->post('saldo',true)-$cobros->total;
        if ($saldo==0) {
          $datac=array
          (
            'cancelado' =>1,
            'fpago'   =>NULL,
          );
        } else {
          $suma=tiempoCuota($this->input->post('pcuota',true));
          $posterior=SumarFecha($suma,$this->input->post('fpago',true));
          $datac=array('fpago'=>$posterior);
        }
        $actualizar=$this->nventa_model->update($datac,$id);

        $this->session->set_flashdata("css", "success");
        $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
      }
      redirect(base_url()."cobrar");
    }

    $datos=$this->nventa_model->mostrar($id);
    $pagos=$this->cobro_model->mostrarTotal(array("p.nulo"=>0,"p.idnventa"=>$id));
    $mpagos=$this->tpago_model->mostrarTotal();
    $this->layout->setTitle("Cuenta por cobrar");
    $this->layout->view("cobrari",compact("establecimientos","nestablecimiento","datos","pagos","mpagos"));
  }

  public function cobrarci($id)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->input->post())
    {
      if ($this->input->post('importe',true)>$this->input->post('saldo',true)) {
        $this->session->set_flashdata("css", "danger");
        $this->session->set_flashdata("mensaje", "El monto es mucho mayor al que tiene que cobrar");
      } else {
        $data=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          'iduser'            =>$this->session->userdata('id'),
          'idventa'           =>$id,
          'femision'          =>date("Y-m-d"),
          'total'             =>$this->input->post('importe',true),
          'idtpago'           =>$this->input->post('mpago',true),
        );
        $insertar=$this->cobroe_model->insert($data);

        $cobros=$this->cobroe_model->montoTotal(array("nulo"=>0,"idventa"=>$id));
        $saldo=$this->input->post('saldo',true)-$cobros->total;
        if ($saldo==0) {
          $datac=array
          (
            'cancelado' =>1,
            'fpago'   =>NULL,
          );
        } else {
          $suma=tiempoCuota($this->input->post('pcuota',true));
          $posterior=SumarFecha($suma,$this->input->post('fpago',true));
          $datac=array('fpago'=>$posterior);
        }
        $actualizar=$this->venta_model->update($datac,$id);

        $this->session->set_flashdata("css", "success");
        $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
      }
      redirect(base_url()."cobrar");
    }

    $datos=$this->venta_model->mostrar($id);
    $pagos=$this->cobroe_model->mostrarTotal(array("p.nulo"=>0,"p.idventa"=>$id));
    $mpagos=$this->tpago_model->mostrarTotal();
    $this->layout->setTitle("Cuenta por cobrar");
    $this->layout->view("cobrari",compact("establecimientos","nestablecimiento","datos","pagos","mpagos"));
  }


}
