<?php
defined("BASEPATH") OR exit('No direct script access allowed');

class Compra extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("departamento_model");
		$this->load->model("provincia_model");
		$this->load->model("distrito_model");
		$this->load->model("tpago_model");
		$this->load->model("proveedor_model");
		$this->load->model("solicitud_model");
		$this->load->model("solicitudd_model");
		$this->load->model("compra_model");
		$this->load->model("comprad_model");
		$this->load->model("kardex_model");
		$this->load->model("lote_model");
		$this->load->model("pago_model");
		$this->load->library("mytcpdf");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$inicio=$this->input->post("inicio",true)!=null ? $this->input->post("inicio",true) : SumarFecha("-15 day",date("Y-m-d")) ;
		$fin=$this->input->post("fin",true)!=null ? $this->input->post("fin",true) : date("Y-m-d") ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->compra_model->mostrarTotal($filtros);
		$this->layout->setTitle("Compra Producto");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin"));
	}

  public function busDatos($tipo,$numero)
  {
    if ($tipo==1) {
			$ruta="https://api.apis.net.pe/v1/dni?numero=".$numero;
		}else{
			$ruta="https://api.apis.net.pe/v1/ruc?numero=".$numero;
		}

		$curl = curl_init();
		curl_setopt_array($curl, array(
		  // para user api versión 1
		  CURLOPT_URL => $ruta,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => 0,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 2,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		));
		$response = curl_exec($curl);
		curl_close($curl);
    return $response;
  }

	public function proveedori()
	{
		if ($this->input->post("tipo",true))
		{
			$consulta=$this->proveedor_model->contador($this->input->post("documento",true));
			if ($consulta==0) {
				$data=array
				(
					"tdocumento"	=>$this->input->post("tipo",true),
					"documento"		=>$this->input->post("documento",true),
					"nombres"		=>trim(mb_strtoupper($this->input->post('nombres',true), 'UTF-8')),
					"iddepartamento"	=>$this->input->post("departamento",true),
					"idprovincia"		=>$this->input->post("provincia",true),
					"iddistrito"		=>$this->input->post("distrito",true),
					"direccion"		=>$this->input->post("direccion",true),
					"telefono"		=>$this->input->post("telefono",true),
					"email"			=>$this->input->post("email",true),
				);

				$insertar=$this->proveedor_model->insert($data);
				$datos['success'] = true;
				$datos['data'] = array("idproveedor"=>$insertar,"proveedor"=>$this->input->post("nombres",true));
			} else {
				$datos['success'] = false;
				$datos['data'] = "El numero de documento ya fue ingresado";
			}
			echo json_encode($datos);
			exit();
		}

		$clientes=json_decode($this->busDatos($this->input->post("identidad",true),$this->input->post("numero",true)));
    $departamentos=$this->departamento_model->mostrarTotal();
    $provincias=$this->provincia_model->mostrarTotal(substr($clientes->ubigeo??'',0,2));
    $distritos=$this->distrito_model->mostrarTotal(substr($clientes->ubigeo??'',0,4));
		$this->layout->setLayout("blanco");
		$this->layout->view("proveedori",compact("departamentos","provincias","distritos","clientes"));
	}

	public function busProveedor()
	{
		if ($this->input->post())
		{
      $datos=$this->proveedor_model->mostrar(array("documento"=>$this->input->post('id',true)));
      echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busNombre()
	{
		if ($this->input->post())
		{
			if (strlen($this->input->post('id',true))>2) {
				$datos=$this->proveedor_model->buscador($this->input->post('id',true));
			} else {
				$datos=$this->proveedor_model->mostrarLimite();
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function ordeni($id)
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$solicitud=$this->solicitud_model->mostrar($id);
		$detalles=$this->solicitudd_model->mostrarTotal($id);
		$mpagos=$this->tpago_model->mostrarTotal();
		$this->layout->setTitle("Compra Producto");
		$this->layout->view("ordeni",compact("establecimientos","nestablecimiento","mpagos","solicitud","detalles","id"));
	}

	public function comprai()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$mpagos=$this->tpago_model->mostrarTotal();
		$this->layout->setTitle("Compra Producto");
		$this->layout->view("comprai",compact("establecimientos","nestablecimiento","mpagos"));
	}

	public function guardar($id=null)
	{
		$empresa=$this->empresa_model->mostrar();
		if ($this->input->post())
		{
			$url='';
			if ($this->input->post("idproducto",true)==null) {
				$mensaje='No envio productos en la compra!';
			} else {
				$consulta=$this->compra_model->contador(array("nulo"=>0,"idproveedor"=>$this->input->post("idproveedor",true),"serie"=>$this->input->post("serie",true),"numero"=>$this->input->post("numero",true)));
				if ($consulta==0) {
					$data=array
			    (
			    	"idestablecimiento"	=>$this->session->userdata("predeterminado"),
			      "iduser"    				=>$this->session->userdata('id'),
			      "femision"    			=>$this->input->post("fecha",true),
			      "comprobante" 			=>$this->input->post("comprobante",true),
			      "serie"     				=>$this->input->post("serie",true),
			      "numero"    				=>$this->input->post("numero",true),
			      "idproveedor" 			=>$this->input->post("idproveedor",true),
			      "proveedor"   			=>$this->input->post("proveedor",true),
			      "subtotal"    			=>$this->input->post("subtotal",true),
			      "igv"      					=>$this->input->post("igv",true),
			      "total"   					=>$this->input->post("total",true),
			      "percepcion"  			=>$this->input->post("mpercepcion",true),
						"porcentaje"				=>$this->input->post("porcentaje",true),
						"incluye"						=>valor_check($this->input->post("incluye",true)),
			      "condicion"   			=>$this->input->post("tpago",true),
			    );
					if ($empresa->compra==0) {
						$data["almacen"]=1;
					}
			    if ($this->input->post("tpago",true)==1) {
						$data["cancelado"]=1;
			    }
			    $insertar=$this->compra_model->insert($data);

			    if ($this->input->post('tpago',true)==1) {
				    $datap=array
		        (
		        	'idestablecimiento'	=>$this->session->userdata("predeterminado"),
		          'iduser'      			=>$this->session->userdata('id'),
		          'idcompra'    			=>$insertar,
		          'femision'    			=>date("Y-m-d"),
		          'total'     				=>$this->input->post('total',true),
		          'idtpago'     			=>$this->input->post('mpago',true),
		        );
						$insertarp=$this->pago_model->insert($datap);
					}

			    for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
			      $datad=array
			      (
			        "idcompra"    =>$insertar,
			        "idproducto"  =>$this->input->post("idproducto",true)[$i],
			        "descripcion" =>trim($this->input->post("descripcion",true)[$i]),
			        "unidad"      =>$this->input->post("unidad",true)[$i],
			        "factor"      =>$this->input->post("factor",true)[$i],
			        "cantidad"    =>$this->input->post("cantidad",true)[$i],
			        "precio"      =>$this->input->post("precio",true)[$i],
			        "importe"     =>$this->input->post("importe",true)[$i],
			        "calmacen"    =>$this->input->post("almacenc",true)[$i],
			        "palmacen"    =>$this->input->post("almacenp",true)[$i],
			        "lote"        =>$this->input->post("lote",true)[$i],
			        "fvencimiento"=>valor_fecha($this->input->post("fvencimiento",true)[$i]),
			      );
			      $insertard=$this->comprad_model->insert($datad);

			      if ($empresa->compra==0) {
							if (valor_check($this->input->post("incluye",true))==0 && $this->input->post("porcentaje",true)>0) {
			          $totalu=round($this->input->post("importe",true)[$i]+($this->input->post("importe",true)[$i]*0.18),2);
			          $preciou=round($totalu/$this->input->post("almacenc",true)[$i],2);
			          $preciom=round($this->input->post("precio",true)[$i]+($this->input->post("precio",true)[$i]*0.18),2);
			        } else {
			          $totalu=$this->input->post("importe",true)[$i];
			          $preciou=$this->input->post("almacenp",true)[$i];
			          $preciom=$this->input->post("precio",true)[$i];
			        }

			        $saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i]);
			        $inicalf=$saldos==null ? 0: $saldos->saldof;
			        $inicalv=$saldos==null ? 0: $saldos->saldov;

			        $saldof=$inicalf+$this->input->post("almacenc",true)[$i];
			        $saldov=$inicalv+$totalu;
			        $datak=array
			        (
			        	"idestablecimiento"	=>$this->session->userdata("predeterminado"),
			          'iduser'    				=>$this->session->userdata('id'),
			          "fecha"     				=>date("Y-m-d"),
			          "idtmovimiento" 		=>2,
			          "concepto"    			=>"Compra",
			          "idproducto"  			=>$this->input->post("idproducto",true)[$i],
			          "descripcion" 			=>trim($this->input->post("descripcion",true)[$i]),
			          "entradaf"    			=>$this->input->post("almacenc",true)[$i],
			          "saldof"    				=>$saldof,
			          "costo"     				=>$preciou,
			          "entradav"    			=>$totalu,
			          "saldov"    				=>$saldov,
			          "documento"   			=>$this->input->post("serie",true)."-".$this->input->post("numero",true),
			        );
			        $insertark=$this->kardex_model->insert($datak);

			        if ($this->input->post("almacenc",true)[$i]==$this->input->post("cantidad",true)[$i]) {
			          $producto=$this->producto_model->mostrar(array("p.id"=>$this->input->post("idproducto",true)[$i]));
			          $preciom=$preciou*$producto->factor;
			        }
			        $datap=array
			        (
			          "compra"  =>$preciom,
			          "pcompra" =>$preciou,
			        );
			        $actualizar=$this->producto_model->update($datap,$this->input->post("idproducto",true)[$i]);

			        $datas=array('stock'=>$saldof);
							$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i]));

			        if ($this->input->post("lote",true)[$i]!="") {
			          $consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$this->input->post("lote",true)[$i]));

			          if ($consultal==null) {
			            $datal=array
			            (
			            	'idestablecimiento'	=>$this->session->userdata("predeterminado"),
			              'idproducto'  			=>$this->input->post("idproducto",true)[$i],
			              'nlote'     				=>$this->input->post("lote",true)[$i],
			              'fvencimiento'  		=>valor_fecha($this->input->post("fvencimiento",true)[$i]),
			              'inicial'   				=>$this->input->post("almacenc",true)[$i],
			              'stock'     				=>$this->input->post("almacenc",true)[$i],
			            );
			            $insertarl=$this->lote_model->insert($datal);
			          } else {
			            $datal=array("stock"=>$consultal->stock+$this->input->post("almacenc",true)[$i]);
			            $actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$this->input->post("lote",true)[$i]);
			          }
			        }
			      }
			    }

			    if ($id!=null) {
						$datat=array("estado"=>2);
						$actualizar=$this->solicitud_model->update($datat,$id);
			    }

					$mensaje='Los datos se han guardado exitosamente!';
	        $url=base_url().'compra';
				} else {
					$mensaje='El comprobante ya existe';
				}
			}

      $datos['mensaje']=$mensaje;
      $datos['url']=$url;
      echo json_encode($datos);
      exit();
		}
	}

	public function comprae($id)
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$datos=$this->compra_model->mostrar($id);
		$detalles=$this->comprad_model->mostrarTotal($id);
		$this->layout->setTitle("Compra Producto");
		$this->layout->view("comprae",compact("establecimientos","nestablecimiento","datos","detalles","id"));
	}

	public function actualizar($id)
	{
		if ($this->input->post())
		{
			$url='';
			if ($this->input->post("idproducto",true)==null) {
				$mensaje='No envio productos en la compra!';
			} else {
				$data=array
				(
					"femision"				=>$this->input->post("fecha",true),
					"comprobante"			=>$this->input->post("comprobante",true),
					"serie"						=>$this->input->post("serie",true),
					"numero"					=>$this->input->post("numero",true),
					"idproveedor"			=>$this->input->post("idproveedor",true),
					"proveedor"				=>$this->input->post("proveedor",true),
					"subtotal"				=>$this->input->post("subtotal",true),
					"igv"							=>$this->input->post("igv",true),
					"total"						=>$this->input->post("total",true),
					"percepcion"			=>$this->input->post("mpercepcion",true),
					"porcentaje"			=>$this->input->post("porcentaje",true),
					"incluye"					=>valor_check($this->input->post("incluye",true)),
				);
				$actualizar=$this->compra_model->update($data,$id);

				$datap=array('total'=>$this->input->post('total',true));
				$actualizarp=$this->pago_model->update($datap,array("idcompra"=>$id));

				for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
					if (isset($this->input->post("id",true)[$i])) {
						$datad=array
						(
							"idcompra"		=>$id,
							"idproducto"	=>$this->input->post("idproducto",true)[$i],
							"descripcion"	=>trim($this->input->post("descripcion",true)[$i]),
							"unidad"			=>$this->input->post("unidad",true)[$i],
							"factor"      =>$this->input->post("factor",true)[$i],
							"cantidad"		=>$this->input->post("cantidad",true)[$i],
							"precio"			=>$this->input->post("precio",true)[$i],
							"importe"			=>$this->input->post("importe",true)[$i],
							"calmacen"		=>$this->input->post("almacenc",true)[$i],
							"palmacen"		=>$this->input->post("almacenp",true)[$i],
							"lote"				=>$this->input->post("lote",true)[$i],
							"fvencimiento"=>valor_fecha($this->input->post("fvencimiento",true)[$i]),
						);
						$actualizard=$this->comprad_model->update($datad,$this->input->post("id",true)[$i]);
					} else {
						$datad=array
						(
							"idcompra"		=>$id,
							"idproducto"	=>$this->input->post("idproducto",true)[$i],
							"descripcion"	=>trim($this->input->post("descripcion",true)[$i]),
							"unidad"			=>$this->input->post("unidad",true)[$i],
							"factor"      =>$this->input->post("factor",true)[$i],
							"cantidad"		=>$this->input->post("cantidad",true)[$i],
							"precio"			=>$this->input->post("precio",true)[$i],
							"importe"			=>$this->input->post("importe",true)[$i],
							"calmacen"		=>$this->input->post("almacenc",true)[$i],
							"palmacen"		=>$this->input->post("almacenp",true)[$i],
							"lote"				=>$this->input->post("lote",true)[$i],
							"fvencimiento"=>valor_fecha($this->input->post("fvencimiento",true)[$i]),
						);
						$insertard=$this->comprad_model->insert($datad);
					}
				}

				$mensaje='Los datos se han guardado exitosamente!';
	      $url=base_url().'compra';
			}

      $datos['mensaje']=$mensaje;
      $datos['url']=$url;
      echo json_encode($datos);
      exit();
		}
	}

	public function almacen($id)
	{
		if ($this->input->post())
		{
			$url='';
			for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
				if ($this->input->post("incluye",true)==0 && $this->input->post("porcentaje",true)>0) {
					$totalu=round($this->input->post("importe",true)[$i]+($this->input->post("importe",true)[$i]*0.18),2);
					$preciou=round($totalu/$this->input->post("almacenc",true)[$i],2);
					$preciom=round($this->input->post("precio",true)[$i]+($this->input->post("precio",true)[$i]*0.18),2);
				} else {
					$totalu=$this->input->post("importe",true)[$i];
					$preciou=$this->input->post("almacenp",true)[$i];
					$preciom=$this->input->post("precio",true)[$i];
				}

				$saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i]);
				$inicalf=$saldos==null ? 0: $saldos->saldof;
				$inicalv=$saldos==null ? 0: $saldos->saldov;

				$saldof=$inicalf+$this->input->post("almacenc",true)[$i];
				$saldov=$inicalv+$totalu;
				$datak=array
				(
					"idestablecimiento"	=>$this->session->userdata("predeterminado"),
					'iduser'						=>$this->session->userdata('id'),
					"fecha"							=>date("Y-m-d"),
					"idtmovimiento"			=>2,
					"concepto"					=>"Compra",
					"idproducto"				=>$this->input->post("idproducto",true)[$i],
					"descripcion"				=>trim($this->input->post("descripcion",true)[$i]),
					"entradaf"					=>$this->input->post("almacenc",true)[$i],
					"saldof"						=>$saldof,
					"costo"							=>$preciou,
					"entradav"					=>$totalu,
					"saldov"						=>$saldov,
					"documento"					=>$this->input->post("documento",true),
				);
				$insertark=$this->kardex_model->insert($datak);

				if ($this->input->post("almacenc",true)[$i]==$this->input->post("cantidad",true)[$i]) {
          $producto=$this->producto_model->mostrar(array("p.id"=>$this->input->post("idproducto",true)[$i]));
          $preciom=$preciou*$producto->factor;
        }
        $datap=array
        (
          "compra"  =>$preciom,
          "pcompra" =>$preciou,
        );
        $actualizar=$this->producto_model->update($datap,$this->input->post("idproducto",true)[$i]);

        $datas=array('stock'=>$saldof);
				$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i]));

				if ($this->input->post("lote",true)[$i]!="") {
          $consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$this->input->post("lote",true)[$i]));

          if ($consultal==null) {
            $datal=array
            (
            	'idestablecimiento'	=>$this->session->userdata("predeterminado"),
              'idproducto'  			=>$this->input->post("idproducto",true)[$i],
              'nlote'     				=>$this->input->post("lote",true)[$i],
              'fvencimiento'  		=>valor_fecha($this->input->post("fvencimiento",true)[$i]),
              'inicial'   				=>$this->input->post("almacenc",true)[$i],
              'stock'     				=>$this->input->post("almacenc",true)[$i],
            );
            $insertarl=$this->lote_model->insert($datal);
          } else {
            $datal=array("stock"=>$consultal->stock+$this->input->post("almacenc",true)[$i]);
            $actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$this->input->post("lote",true)[$i]);
          }
        }
			}

			$data=array("almacen"=>1);
			$actualizar=$this->compra_model->update($data,$id);

			$datos['mensaje']='Se ingreso al almacen exitosamente!';
      $datos['url']=base_url().'compra';
      echo json_encode($datos);
      exit();
		}

		$datos=$this->compra_model->mostrar($id);
		$detalles=$this->comprad_model->mostrarTotal($id);
		$this->layout->setTitle("Ingreso Compra");
		$this->layout->view("almacen",compact("datos","detalles","id"));
	}

	public function compraa($id)
	{
		$datos=$this->compra_model->mostrar($id);
		if ($datos->nulo==0) {
			if ($datos->almacen==1) {
				$detalles=$this->comprad_model->mostrarTotal($id);
				foreach ($detalles as $detalle) {
					if ($datos->incluye==0 && $datos->porcentaje>0) {
						$total=round($detalle->importe+($detalle->importe*0.18),2);
						$costo=round($total/$detalle->calmacen,2);
					} else {
						$total=$detalle->importe;
						$costo=$detalle->palmacen;
					}

					$saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
					$inicalf=$saldos==null ? 0: $saldos->saldof;
					$inicalv=$saldos==null ? 0: $saldos->saldov;

					$saldof=$inicalf-$detalle->calmacen;
					$saldov=$inicalv-$total;
					$datak=array
					(
						"idestablecimiento"	=>$datos->idestablecimiento,
						"iduser"						=>$this->session->userdata('id'),
						"fecha"							=>date("Y-m-d"),
						"idtmovimiento"			=>2,
						"concepto"					=>"Anulacion Compra",
						"idproducto"				=>$detalle->idproducto,
						"descripcion"				=>$detalle->descripcion,
						"salidaf"						=>$detalle->calmacen,
						"saldof"						=>$saldof,
						"costo"							=>$costo,
						"salidav"						=>$total,
						"saldov"						=>$saldov,
						"documento"					=>$datos->serie."-".$datos->numero,
					);
					//var_dump($datak);
					$insertark=$this->kardex_model->insert($datak);

					$datas=array("stock"=>$saldof);
					$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

					if ($detalle->lote!='') {
						$consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$detalle->lote));
						if ($consultal->stock>$detalle->calmacen) {
							$datal=array("stock"=>$consultal->stock-$detalle->calmacen);
							$actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$detalle->lote);
						} else {
							$elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$detalle->lote));
						}
					}
				}
			}

			$datap=array
			(
				"nulo"	 	=>1,
				"total"	=>"0.00",
			);
			$actualizap=$this->pago_model->update($datap,array("idcompra"=>$id));

			$data=array
			(
				"nulo"	 			=>1,
				"proveedor"		=>"(Anulado)".$datos->proveedor,
				"subtotal"		=>"0.00",
				"igv"					=>"0.00",
				"total"				=>"0.00",
			);
			$actualiza=$this->compra_model->update($data,$id);
			echo "borrado";
		}else{
			echo "no borrado";
		}
	}

	public function pagos($id)
	{
		$datos=$this->compra_model->mostrar($id);
		$listas=$this->pago_model->mostrarTotal(array("idcompra"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("pagos",compact("datos","listas"));
	}

	public function pdfcompra($id)
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->compra_model->mostrar($id);
		$detalles=$this->comprad_model->mostrarTotal($id);
		$proveedor=$this->proveedor_model->mostrar(array("p.id"=>$datos->idproveedor));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfcompra",compact("empresa","nestablecimiento","datos","detalles","proveedor","id"));
  }

	public function consulta($id)
	{
		$datos=$this->compra_model->mostrar($id);
		$detalles=$this->comprad_model->mostrarTotal($id);
		$this->layout->setLayout("blanco");
		$this->layout->view("consulta",compact("datos","detalles"));
	}






}
