<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Consulta extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("mes_model");
		$this->load->model("compra_model");
		$this->load->model("nventa_model");
		$this->load->model("venta_model");
		$this->load->model("nota_model");
		$this->load->model("bonificado_model");
		$this->load->model("kardex_model");
		$this->load->library("mytcpdf");
	}

  public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : date("Y-m-d") ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;

		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin));
		$this->layout->setTitle("Ventas Valorizado");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin"));
	}

	public function pdfventav($inicio,$fin)
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfventav",compact("empresa","nestablecimiento","listas","inicio","fin"));
  }

  public function excelventav($inicio,$fin)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin));

		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setTitle("Venta Valorizada");

		$sheet->mergeCells("A1:H1");
		$sheet->mergeCells("A2:H2");

		$sheet->getStyle("A1:H3")->getFont()->setBold(true);
		$sheet->getStyle("A1:H3")->getAlignment()->setHorizontal("center");

		$sheet->setCellValueByColumnAndRow(1, 1,"VENTAS VALORIZADAS DEL ".$inicio." AL ".$fin);

		$styleArray = [
		    'borders' => [
		        'top' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'bottom' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'left' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'right' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		    ],
		];

		foreach(range("A","H") as $columnID) {
		    $sheet->getColumnDimension($columnID)->setAutoSize(true);
		    $sheet->getStyle($columnID."3")->applyFromArray($styleArray);
		}

		$sheet->setCellValueByColumnAndRow(1, 3,"#");
		$sheet->setCellValueByColumnAndRow(2, 3,"Producto");
		$sheet->setCellValueByColumnAndRow(3, 3,"Cantidad");
		$sheet->setCellValueByColumnAndRow(4, 3,"(Dscto)");
		$sheet->setCellValueByColumnAndRow(5, 3,"Ventas");
		$sheet->setCellValueByColumnAndRow(6, 3,"Costo Prom.");
		$sheet->setCellValueByColumnAndRow(7, 3,"Utilidad");
		$sheet->setCellValueByColumnAndRow(8, 3,"Margen (%)");

		$i=4;
		$n=1;
    $tcompra=0;
    $tventa=0;
    $tutilidad=0;
    foreach ($listas as $lista) {
	    $notas=$this->nota_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin,"nulo"=>0,"idproducto"=>$lista->idproducto));
	    $cantidad=$lista->cantidad-$notas->cantidad;
	    $venta=$lista->importe-$notas->importe;

	    $compra=$lista->costo-$notas->costo;//
	    $utilidad=$venta-$compra;
      $margen=gananciav($venta,$compra,1);

			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);
			$sheet->getStyle("F".$i)->applyFromArray($styleArray);
			$sheet->getStyle("G".$i)->applyFromArray($styleArray);
			$sheet->getStyle("H".$i)->applyFromArray($styleArray);

			$sheet->setCellValue("A".$i,$n);
			$sheet->setCellValue("B".$i,$lista->descripcion);
			$sheet->setCellValue("C".$i,$cantidad);
			$sheet->setCellValue("D".$i,$lista->dscto);
			$sheet->setCellValue("E".$i,$venta);
			$sheet->setCellValue("F".$i,$compra);
			$sheet->setCellValue("G".$i,$utilidad);
			$sheet->setCellValue("H".$i,$margen);

			$tcompra+=$compra;
		  $tventa+=$venta;
		  $tutilidad+=$utilidad;
			$i++; $n++;
		}

		$sheet->setCellValue("A".$i,'Totales');
		$sheet->setCellValue("E".$i,$tventa);
		$sheet->setCellValue("F".$i,$tcompra);
		$sheet->setCellValue("G".$i,$tutilidad);

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="VENTAS_VALORIZADAS'.$nestablecimiento->descripcion.'.xlsx"');
    $writer->save('php://output');	// download file
	}

  public function ventau()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : date("Y-m-d") ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;
		$user=$this->input->post('usuario',true)!=null ? $this->input->post('usuario',true) : '' ;

		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin,"iduser"=>$user));
		$usuarios=$this->usuario_model->activos();
		$this->layout->setTitle("Ventas Valorizado");
		$this->layout->view("ventau",compact("establecimientos","nestablecimiento","listas","inicio","fin","usuarios","user"));
	}

	public function pdfventau($inicio,$fin,$user)
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin,"iduser"=>$user));
		$usuarios=$this->usuario_model->mostrar($user);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfventau",compact("empresa","nestablecimiento","listas","inicio","fin","user","usuarios"));
  }

    public function excelventau($inicio,$fin,$user)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin,"iduser"=>$user));
		$usuarios=$this->usuario_model->mostrar($user);

		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setTitle("Venta Valorizada");

		$sheet->mergeCells("A1:F1");
		$sheet->mergeCells("A2:F2");

		$sheet->getStyle("A1:F3")->getFont()->setBold(true);
		$sheet->getStyle("A1:F3")->getAlignment()->setHorizontal("center");

		$sheet->setCellValueByColumnAndRow(1, 1,"VENTAS VALORIZADAS DEL ".$inicio." AL ".$fin." DEL USUARIO ".$usuarios->nombres);

		$styleArray = [
		    'borders' => [
		        'top' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'bottom' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'left' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'right' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		    ],
		];

		foreach(range("A","F") as $columnID) {
		    $sheet->getColumnDimension($columnID)->setAutoSize(true);
		    $sheet->getStyle($columnID."3")->applyFromArray($styleArray);
		}

		$sheet->setCellValueByColumnAndRow(1, 3,"#");
		$sheet->setCellValueByColumnAndRow(2, 3,"Producto");
		$sheet->setCellValueByColumnAndRow(3, 3,"Cantidad");
		$sheet->setCellValueByColumnAndRow(4, 3,"Ventas");
		$sheet->setCellValueByColumnAndRow(5, 3,"Costo Prom.");
		$sheet->setCellValueByColumnAndRow(6, 3,"Utilidad");

		$i=4;
		$n=1;
	    $tcompra=0;
	    $tventa=0;
	    $tutilidad=0;
	    foreach ($listas as $lista) {
	    $notas=$this->nota_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin,"nulo"=>0,"idproducto"=>$lista->idproducto,"iduser"=>$user));
	    $cantidad=$lista->cantidad-$notas->cantidad;
	    $venta=$lista->importe-$notas->importe;

	    $compra=$lista->costo-$notas->costo;//
	    $utilidad=$venta-$compra;

			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);
			$sheet->getStyle("F".$i)->applyFromArray($styleArray);

			$sheet->setCellValue("A".$i,$n);
			$sheet->setCellValue("B".$i,$lista->descripcion);
			$sheet->setCellValue("C".$i,$cantidad);
			$sheet->setCellValue("D".$i,$venta);
			$sheet->setCellValue("E".$i,$compra);
			$sheet->setCellValue("F".$i,$utilidad);

			$tcompra+=$compra;
		  $tventa+=$venta;
		  $tutilidad+=$utilidad;
			$i++; $n++;
		}

		$sheet->setCellValue("A".$i,'Totales');
		$sheet->setCellValue("D".$i,$tventa);
		$sheet->setCellValue("E".$i,$tcompra);
		$sheet->setCellValue("F".$i,$tutilidad);

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="VENTAS_VALORIZADAS_USUARIO'.$nestablecimiento->descripcion.'.xlsx"');
    $writer->save('php://output');	// download file
	}

  public function vhorario()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-7 day',date("Y-m-d")) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;
		$this->layout->setTitle("Ventas Horario");
		$this->layout->view("vhorario",compact("establecimientos","nestablecimiento","inicio","fin"));
	}

	public function ventash()
	{
		$hinicial="07:00";
		$datos=array();
		for ($i=0; $i < 16; $i++) {
			$j=$i+1;
			$horarioi=SumarHora('+'.$i.' hour',$hinicial);
			$horariof=SumarHora('+'.$j.' hour',$hinicial);
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"hemision>="=>$horarioi,"hemision<="=>$horariof,"femision>="=>$this->input->post('inicio',true),"femision<="=>$this->input->post('fin',true));
			$cantidadn=$this->nventa_model->contador($filtros);
			$cantidadv=$this->venta_model->contador($filtros);
			$cantidad=$cantidadn+$cantidadv;

			$horas['horas']=date('H:i',strtotime($horarioi));
			$horas['ventas']=$cantidad;
			array_push($datos,$horas);
		}
		echo json_encode($datos);
		//var_dump($datos);
	}

  public function stockv()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$listas=$this->inventario_model->productosStock($this->session->userdata("predeterminado"));
		$this->layout->setTitle("Stock Valorizado");
		$this->layout->view("stockv",compact("establecimientos","nestablecimiento","empresa","listas"));
	}

	public function pdfstockv()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$listas=$this->inventario_model->productosStock($this->session->userdata("predeterminado"));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfstockv",compact("empresa","nestablecimiento","listas"));
  }

	public function kardex()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$finicio = $this->input->post('finicio',true)!=null ? $this->input->post('finicio',true) : date("Y-m-d") ;
		$ffinal = $this->input->post('ffinal',true)!=null ? $this->input->post('ffinal',true) : date("Y-m-d") ;
		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"fecha>="=>$finicio,"fecha<="=>$ffinal);
		$listas=$this->kardex_model->mostrarTotal($filtros);
		$this->layout->setLayout("contraido");
		$this->layout->setTitle("Kardex");
		$this->layout->view("kardex",compact("establecimientos","nestablecimiento","listas","finicio","ffinal"));
	}

	public function producto()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$idproducto = $this->input->post('idproducto',true)!=null ? $this->input->post('idproducto',true) : '' ;
		$descripcion = $this->input->post('descripcion',true)!=null ? $this->input->post('descripcion',true) : "" ;
		$finicio = $this->input->post('finicio',true)!=null ? $this->input->post('finicio',true) : date("Y-m-d") ;
		$ffinal = $this->input->post('ffinal',true)!=null ? $this->input->post('ffinal',true) : date("Y-m-d") ;
		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"fecha>="=>$finicio,"fecha<="=>$ffinal,"idproducto"=>$idproducto);
		$listas=$this->kardex_model->mostrarTotal($filtros);
		$this->layout->setLayout("contraido");
		$this->layout->setTitle("Kardex");
		$this->layout->view("producto",compact("establecimientos","nestablecimiento","listas","idproducto","descripcion","finicio","ffinal"));
	}

	public function lote()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$envio_datos=$this->input->post();
		$listas=$this->lote_model->mostrarTotal($this->session->userdata("predeterminado"),$this->input->post('idproducto',true));
		$this->layout->setTitle("Kardex Lote");
		$this->layout->view("lote",compact("establecimientos","nestablecimiento","listas","envio_datos"));
	}

  public function bvendedor()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$canuo=$this->input->post('canuo',true)!=null ? $this->input->post('canuo',true) : '';
		$cmes=$this->input->post('cmes',true)!=null ? $this->input->post('cmes',true) : '';
		$nusuario=$this->input->post('nusuario',true)!=null ? $this->input->post('nusuario',true) : '';
		$anuos=$this->periodo_model->mostrarTotal();
		$meses=$this->mes_model->mostrarTotal();
		$usuarios=$this->usuario_model->activos();

		$listas=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"year(femision)"=>$canuo,"month(femision)"=>$cmes,"iduser"=>$nusuario));
		$this->layout->setTitle("Bonificaciones Vendedor");
		$this->layout->view("bvendedor",compact("establecimientos","nestablecimiento","canuo","cmes","nusuario","anuos","meses","usuarios","listas"));
	}




}
