<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Empresa extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
	}

	public function index()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		if ($this->input->post())
		{
			$data=array
			(
				"ruc"								=>$this->input->post("ruc",true),
				"nombres"						=>$this->input->post("nombres",true),
				"ncomercial"				=>$this->input->post("ncomercial",true),
				"producto"					=>$this->input->post("producto",true),
				"dscto"							=>$this->input->post("dscto",true),
				"ticket"						=>$this->input->post("ticket",true),
				"pie"								=>$this->input->post("pie",true),
			);
			$guardar=$this->empresa_model->update($data);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");

			if (isset($_FILES['logo']) && $_FILES['logo']['tmp_name']!='') {
				$nombreCompleto=$_FILES['logo']['name'];

				$config['upload_path']   = './public/logo/';
				$config['overwrite'] = TRUE;
				$config['allowed_types'] = 'jpg|jpeg|png';
				$config['max_size']      = 2000;
				$config['max_width']     = 0;
				$config['max_height']    = 0;
				$config['file_name']     = $nombreCompleto;
				$this->load->library('upload', $config);

				if (!$this->upload->do_upload('logo')) {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', $this->upload->display_errors());
				} else {
					$ruta= addslashes(base_url()."public/logo/".$nombreCompleto);
					$datai=array('logo'=>$ruta);
					$imagen=$this->upload->data();
					$guardar=$this->empresa_model->update($datai);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Se subio con exito la portada '.$imagen["file_name"]);
				}
			}

			if (isset($_FILES['lticket']) && $_FILES['lticket']['tmp_name']!='') {
				$nombreCompleto=$_FILES['lticket']['name'];

				$config['upload_path']   = './public/logo/';
				$config['overwrite'] = TRUE;
				$config['allowed_types'] = 'jpg|jpeg|png';
				$config['max_size']      = 2000;
				$config['max_width']     = 0;
				$config['max_height']    = 0;
				$config['file_name']     = $nombreCompleto;
				$this->load->library('upload', $config);

				if (!$this->upload->do_upload('lticket')) {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', $this->upload->display_errors());
				} else {
					$ruta= addslashes(base_url()."public/logo/".$nombreCompleto);
					$datai=array('lticket'=>$ruta,);
					$imagen=$this->upload->data();
					$guardar=$this->empresa_model->update($datai);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Se subio con exito logo '.$imagen["file_name"]);
				}
			}
		}

		$datos=$this->empresa_model->mostrar();
		$this->layout->setTitle("Empresa");
		$this->layout->view("index",compact("establecimientos","datos"));
	}

	public function facturacion()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		if ($this->input->post())
		{
			$data=array
			(
				"tipo_soap"					=>$this->input->post("soap",true),
				"usuario_soap"			=>$this->input->post("usuario",true),
				"clave_soap"				=>$this->input->post("secundario",true),
				"certificado_clave"	=>$this->input->post("clave",true),
				"certificado_vence"	=>valor_fecha($this->input->post("vencimiento",true)),
			);
			$guardar=$this->empresa_model->update($data);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");

			if (isset($_FILES['certificado']) && $_FILES['certificado']['tmp_name']!='') {
				$nombreCompleto=$_FILES['certificado']['name'];

				$config['upload_path']   = './downloads/certificado/';
				$config['overwrite'] = TRUE;
				$config['allowed_types'] = '*';
				$config['max_size']      = 2000;
				$config['max_width']     = 0;
				$config['max_height']    = 0;
				$config['file_name']     = $nombreCompleto;
				$this->load->library('upload', $config);

				if (!$this->upload->do_upload('certificado')) {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', $this->upload->display_errors());
				} else {
					//$ruta= addslashes(base_url()."downloads/certificado/".$nombreCompleto);
					$datai=array('certificado'=>$nombreCompleto);
					$imagen=$this->upload->data();
					$guardar=$this->empresa_model->update($datai);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Se subio con exito certificado '.$imagen["file_name"]);
				}
			}
		}

		$datos=$this->empresa_model->mostrar();
		$this->layout->setTitle("Empresa");
		$this->layout->view("facturacion",compact("establecimientos","datos"));
	}

	public function certificadod()
	{
		$datos=$this->empresa_model->mostrar();
		if ($datos==NULL) {show_404();}

		$filename="./downloads/certificado/".$datos->certificado;
		if (file_exists($filename)) {
		    $success = unlink($filename);
		}
		$eliminar=$this->empresa_model->update(array('certificado'=>NULL));
		echo 'borrado';
	}

	public function avanzado()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		if ($this->input->post())
		{
			$data=array
			(
				"compra"					=>$this->input->post("compra",true),
				"pventa"					=>$this->input->post("pventa",true),
				"arqueo"					=>$this->input->post("arqueo",true),
				"pestablecimiento"=>valor_check($this->input->post("pestablecimiento",true)),
			);
			$guardar=$this->empresa_model->update($data);

			if (valor_check($this->input->post("pestablecimiento",true))==1) {
				$catalogos=$this->producto_model->mostrarCatalogo();
        foreach ($catalogos as $catalogo) {
          $datas=array
          (
            'venta'     	=>$catalogo->venta,
            'pventa'     	=>$catalogo->pventa,
            'pblister'    =>$catalogo->pblister,
          );
          $actualizari=$this->inventario_model->update($datas,array("idproducto"=>$catalogo->id));
        }
			}

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
		}

		$datos=$this->empresa_model->mostrar();
		$contador=$this->establecimiento_model->contador();
		$this->layout->setTitle("Empresa");
		$this->layout->view("avanzado",compact("establecimientos","datos","contador"));
	}

	public function backup()
	{
		$this->load->dbutil();
		//Hacemos el backup de los datos que nos interesan
		$prefs = array(
	    'tables'        => array(),                     // Listado de tablas. 'tabla1', 'tabla2'
	    'ignore'        => array(),                     // Listado de tablas a omitir
	    'format'        => 'zip',                       // gzip, zip, txt
	    'filename'      => 'backup.zip',                // Nombre del fichero - SOLAMENTE PARA FICHEROS ZIP
	    'add_drop'      => TRUE,                        // Si agregar la sentencia DROP TABLE al backup
	    'add_insert'    => TRUE,                        // Si agregar la sentencia INSERT al backup
	    'newline'       => "\n"                         // Salto de línea
		);
		$backup = $this->dbutil->backup($prefs);

		//Cargamos el helper file y generamos un fichero
		//Esta parte la usamos solo si deseamos guardarlo en servidor
		// $this->load->helper('file');
		// write_file('downloads/backup/backup.zip', $backup);

		//Cargamos el helper download y forzamos la descarga
		$this->load->helper('download');
		force_download('backup.zip', $backup);
	}

	public function directorio()
	{
		$this->load->library('zip');
		$this->zip->read_dir('downloads/pdf', FALSE);
		$this->zip->download('pdf.zip');
	}


}
