<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Establecimiento extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("departamento_model");
    $this->load->model("provincia_model");
    $this->load->model("distrito_model");
    $this->load->model("serie_model");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

    $listas=$this->establecimiento_model->mostrarTotal();
    $this->layout->setTitle("Establecimientos");
    $this->layout->view("index",compact("establecimientos","listas"));
  }

  public function establecimientoi($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array
        (
          "codigo"      =>$this->input->post("codigo",true),
          "descripcion"   =>$this->input->post("descripcion",true),
          "iddepartamento"  =>$this->input->post("departamento",true),
          "idprovincia"   =>$this->input->post("provincia",true),
          "iddistrito"    =>$this->input->post("distrito",true),
          "direccion"     =>$this->input->post("direccion",true),
          "telefono"      =>$this->input->post("telefono",true),
          "email"       =>$this->input->post("email",true),
          "cdigemid"      =>$this->input->post("cdigemid",true),
        );
        $guardar=$this->establecimiento_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        echo base_url()."establecimiento";
      } else {
        $data=array
        (
          "codigo"      =>$this->input->post("codigo",true),
          "descripcion"   =>$this->input->post("descripcion",true),
          "iddepartamento"  =>$this->input->post("departamento",true),
          "idprovincia"   =>$this->input->post("provincia",true),
          "iddistrito"    =>$this->input->post("distrito",true),
          "direccion"     =>$this->input->post("direccion",true),
          "telefono"      =>$this->input->post("telefono",true),
          "email"       =>$this->input->post("email",true),
          "cdigemid"      =>$this->input->post("cdigemid",true),
        );
        $insertar=$this->establecimiento_model->insert($data);

        $catalogos=$this->producto_model->mostrarCatalogo();
        foreach ($catalogos as $catalogo) {
          $datac=array
          (
            'idestablecimiento' =>$insertar,
            'idproducto'        =>$catalogo->id,
            'stock'             =>0,
          );
          $insertark=$this->inventario_model->insert($datac);
        }

        $this->session->set_flashdata("css", "success");
        $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
        echo base_url()."serie/index/".$insertar;
      }
      exit();
    }

    $datos=$id!=null?$this->establecimiento_model->mostrar($id):(object) array("codigo"=>'',"descripcion"=>'',"iddepartamento"=>'',"idprovincia"=>'',"iddistrito"=>'',"direccion"=>'',"email"=>'',"telefono"=>'',"cdigemid"=>'');
    $departamentos=$this->departamento_model->mostrarTotal();
    $provincias=$this->provincia_model->mostrarTotal($datos->iddepartamento);
    $distritos=$this->distrito_model->mostrarTotal($datos->idprovincia);
    $this->layout->setLayout("blanco");
    $this->layout->view("establecimientoi",compact("datos","departamentos","provincias","distritos"));
  }

  public function busProvincia()
  {
    if ($this->input->post())
    {
      $datos=$this->provincia_model->mostrarTotal($this->input->post("id",true));
      echo json_encode($datos);
    }
    else
    {
      show_404();
    }
  }

  public function busDistrito()
  {
    if ($this->input->post())
    {
      $datos=$this->distrito_model->mostrarTotal($this->input->post("id",true));
      echo json_encode($datos);
    }
    else
    {
      show_404();
    }
  }



}
