<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Facturacion extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("testado_model");
		$this->load->model("kardex_model");
		$this->load->model("lote_model");
		$this->load->model("cliente_model");
		$this->load->model("serie_model");
		$this->load->model("tvalidacion_model");
		$this->load->model("tcomprobante_model");
		$this->load->model("nventa_model");
		$this->load->model("venta_model");
		$this->load->model("ventad_model");
		$this->load->model("cobroe_model");
		$this->load->model("nota_model");
		$this->load->model("notad_model");
		$this->load->model("cobron_model");
		$this->load->model("despacho_model");
		$this->load->model("despachod_model");
		$this->load->model("resumen_model");
		$this->load->model("resumend_model");
		$this->load->model("anulado_model");
    $this->load->model("anuladod_model");

    $this->load->library("generadorXML");
    $this->load->library("firmarXML");
    $this->load->library("apiFacturacion");
    $this->generadoXML = new GeneradorXML();
    $this->firmadoXML = new FirmarXML();
    $this->apiFacturacion = new ApiFacturacion();
	}

	/*=====================================================================================================================
	=                                               comprobantes no enviados                                              =
	=====================================================================================================================*/
	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$filtros=array("grupo"=>'01',"has_cdr"=>0,"tipo_estado"=>"01","rectificar"=>0);
		$listas=$this->venta_model->mostrarTotal($filtros,"asc");
		$listasn=$this->nota_model->mostrarTotal($filtros,"asc");

		$filtros=array("has_cdr"=>0,"tipo_estado"=>"01");
		$listasd=$this->despacho_model->mostrarTotal($filtros,"asc");
		$this->layout->setTitle('Comprobante no Enviado');
		$this->layout->view('index',compact("establecimientos","nestablecimiento",'empresa','listas','listasn','listasd'));
	}

  public function enviarFactura($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->venta_model->mostrar($id);
    $nombre = $empresa->ruc.'-'.$datos->tcomprobante.'-'.$datos->serie.'-'.$datos->numero;
    $rutazip="downloads/xml/".$nombre;
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->EnviarComprobanteElectronico($empresa,$nombre,$rutazip,$rutacdr);
    if (!is_numeric($resultado['codigo_sunat'])) {
      $this->session->set_flashdata('css', 'danger');
    } elseif (obtenerNumero($resultado['codigo_sunat'])===0) {
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"05",
        "respuesta_sunat" =>$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<2000) { //Del 0100 al 1999 Excepciones
      $data=array
      (
        "rectificar"   =>1,
        "respuesta_rectificar" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'info');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<'4000') { //Del 2000 al 3999 Errores que generan rechazo
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"09",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $devolver=$this->devolucion($id);
      $this->session->set_flashdata('css', 'info');
    } else {// 4000 en adelante Observaciones
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"07",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    }

    $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    redirect(base_url().'facturacion');
  }

  public function enviarNota($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->nota_model->mostrar($id);
    $nombre = $empresa->ruc.'-'.$datos->tcomprobante.'-'.$datos->serie.'-'.$datos->numero;
    $rutazip="downloads/xml/".$nombre;
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->EnviarComprobanteElectronico($empresa,$nombre,$rutazip,$rutacdr);
    if (!is_numeric($resultado['codigo_sunat'])) {
      $this->session->set_flashdata('css', 'danger');
    }
    if (obtenerNumero($resultado['codigo_sunat'])===0) {
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"05",
        "respuesta_sunat" =>$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<2000) { //Del 0100 al 1999 Excepciones
      $data=array
      (
        "rectificar"   =>1,
        "respuesta_rectificar" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'info');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<'4000') { //Del 2000 al 3999 Errores que generan rechazo
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"09",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $devolver=$this->devolucionn($id);
      $this->session->set_flashdata('css', 'info');
    } else {// 4000 en adelante Observaciones
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"07",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    }

    $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    redirect(base_url().'facturacion');
  }

	public function devolucion($id)
	{
		$datos=$this->venta_model->mostrar($id);
		$detalles=$this->ventad_model->mostrarTotal($id);
		foreach ($detalles as $detalle) {
			$productos=$this->producto_model->mostrar(array("p.id"=>$detalle->idproducto));

			if ($productos->tipo=='B') {
				$saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
				$inicalf=$saldos==null ? 0: $saldos->saldof;
				$inicalv=$saldos==null ? 0: $saldos->saldov;
				//costos promedio
				$salidav=$detalle->calmacen*$detalle->palmacen;

				$saldof=$inicalf+$detalle->calmacen;
				$saldov=$inicalv+$salidav;
				$datak=array
				(
          "idestablecimiento" =>$datos->idestablecimiento,
					"iduser"		        =>$this->session->userdata('id'),
					"fecha"			        =>date("Y-m-d"),
					"idtmovimiento"	    =>1,
					"concepto"		      =>"Venta Rechazada",
					"idproducto"	      =>$detalle->idproducto,
					"descripcion"	      =>$detalle->descripcion,
					"entradaf"		      =>$detalle->calmacen,
					"saldof"		        =>$saldof,
					"costo"			        =>$detalle->palmacen,
					"entradav"		      =>$salidav,
					"saldov"		        =>$saldov,
					"documento"		      =>$datos->serie."-".$datos->numero,
				);
				$insertark=$this->kardex_model->insert($datak);

				$datas=array("stock"=>$saldof);
				$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

				//---------------  devolucion de lotes  ------------------
				if ($detalle->lote!='') {
					$nlote=explode("|",$detalle->lote);
					$flote=explode("|",$detalle->fvencimiento);
					$clote=explode("|",$detalle->clote);

					for ($l=0; $l < count($nlote) ; $l++) {
						$consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlote[$l]));

						if ($consultal==null) {
							$datal=array
							(
                "idestablecimiento"=>$datos->idestablecimiento,
								"idproducto"	     =>$detalle->idproducto,
								"nlote"				     =>$nlote[$l],
								"fvencimiento"     =>valor_fecha($flote[$l]),
								"inicial"			     =>$clote[$l],
								"stock"				     =>$clote[$l],
							);
							$insertarl=$this->lote_model->insert($datal);
						} else {
							$datal=array("stock"=>$consultal->stock+$clote[$l]);
							$actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$nlote[$l]);
						}
					}
				}
			}
		}

		$datac=array
		(
			"nulo"	 	=>1,
			"total"	=>"0.00",
		);
		$actualizac=$this->cobroe_model->update($datac,array("idventa"=>$id));
		$this->session->set_flashdata('css', 'success');
		$this->session->set_flashdata('mensaje', 'Los producto fueron devueltos a almacen');
	}

	public function devolucionn($id)
	{
		$datos=$this->nota_model->mostrar($id);
		if ($datos->tcomprobante=="07") {
			$detalles=$this->notad_model->mostrarTotal($id);
			foreach ($detalles as $detalle) {
				$productos=$this->producto_model->mostrar(array("p.id"=>$detalle->idproducto));

				if ($productos->tipo=='B') {
					$saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
					$inicalf=$saldos==null ? 0: $saldos->saldof;
					$inicalv=$saldos==null ? 0: $saldos->saldov;
					//costos promedio
					$costo=$inicalf==0 ? 0 : round($inicalv/$inicalf,4);
					$salidav=$detalle->calmacen*$costo;

					$saldof=$inicalf-$detalle->calmacen;
					$saldov=$inicalv-$salidav;
					$datak=array
					(
            "idestablecimiento"=>$datos->idestablecimiento,
						"iduser"		       =>$this->session->userdata('id'),
						"fecha"			       =>date("Y-m-d"),
						"idtmovimiento"	     =>1,
						"concepto"		     =>"Anulacion ".$datos->ncomprobante,
						"idproducto"	     =>$detalle->idproducto,
						"descripcion"	     =>$detalle->descripcion,
						"salidaf"		       =>$detalle->calmacen,
						"saldof"		       =>$saldof,
						"costo"			       =>$costo,
						"salidav"		       =>$salidav,
						"saldov"		       =>$saldov,
						"documento"		     =>$datos->serie."-".$datos->numero,
					);
					//var_dump($datak);
					$insertark=$this->kardex_model->insert($datak);

					$datas=array("stock"=>$saldof);
					$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

					//-------------  devolucion de lotes  -----------------
					if ($detalle->lote!='') {
						$nlotes=explode("|",$detalle->lote);
						$clote=explode("|",$detalle->clote);
						for ($l=0; $l < count($nlotes) ; $l++) {
							$consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlotes[$l]));
							$saldoc=$consultal->stock-$clote;	//saldo a guardar

							if ($saldoc>0) {
								$datal=array('stock'=>$saldoc);
								$actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$nlotes[$l]);
							} else {
								$elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlotes[$l]));
							}
						}
					}
				}
			}
		}

		$datac=array
		(
			"nulo"	 	=>1,
			"total"	=>"0.00",
		);
		$actualizac=$this->cobron_model->update($datac,array("idnota"=>$id));
		$this->session->set_flashdata('css', 'success');
		$this->session->set_flashdata('mensaje', 'Los producto fueron devueltos a almacen');
	}

	public function guiaToken()
	{
		$empresa=$this->empresa_model->mostrar();
		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api-seguridad.sunat.gob.pe/v1/clientessol/'.$empresa->id_gre.'/oauth2/token/',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS => 'grant_type=password&scope=https://api-cpe.sunat.gob.pe&client_id='.$empresa->id_gre.'&client_secret='.urlencode($empresa->secret_gre).'&username='.$empresa->usuario_soap.'&password='.urlencode($empresa->clave_soap).'',
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/x-www-form-urlencoded'
		  ),
		));

		$response = curl_exec($curl);
		curl_close($curl);
		return json_decode($response,true);
	}

	public function enviarGuia($id)
	{
		$empresa=$this->empresa_model->mostrar();
		$limite=fechaHoraria('+ '.$empresa->expires_gre.' second ',$empresa->fecha_gre);
		if (date("Y-m-d H:i:s")>=$limite) {
			$respuesta_json=self::guiaToken();

			$data=array
			(
				'token_gre'	=>$respuesta_json["access_token"],
				'fecha_gre'	=>date("Y-m-d H:i:s"),
				'expires_gre'	=>$respuesta_json["expires_in"],
			);
			$actualizar=$this->empresa_model->mostrarUpdate($data);
		}

    $datos=$this->despacho_model->mostrar($id);
    $nombre = $empresa->ruc.'-'.$datos->tcomprobante.'-'.$datos->serie.'-'.$datos->numero;
    $rutazip="downloads/xml/".$nombre;
    $resultado = $this->apiFacturacion->EnviarGuiaRemision($empresa,$nombre,$rutazip);

    if ($resultado['ticket']!='') {
      $datav=array
      (
        'ticket'    	=>$resultado['ticket'],
        'frecepcion'	=>$resultado['frecepcion'],
        'tipo_estado'	=>'03',
      );
      $actualizar=$this->despacho_model->update($datav,$id);

      sleep(5);
      $mensaje=$this->consultarGuia($id);

      $this->session->set_flashdata('css', 'info');
      $this->session->set_flashdata('mensaje', $mensaje);
    }else{
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    }
    redirect(base_url().'facturacion');
	}

	public function consultarGuia($id)
	{
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->despacho_model->mostrar($id);
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->ConsultarTicketGuia($empresa,$datos->filename,$datos->ticket,$rutacdr);

    if ($resultado['estado']==3) {
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    }elseif ($resultado['estado']==2) {
    	$data=array(
    		"tipo_estado"=>'01',
    		//"ticket"=>NULL,
    	);
      $actualizar=$this->despacho_model->update($data,$id);

      $this->session->set_flashdata('css', 'success');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    } else {
      if (obtenerNumero($resultado['codigo_sunat'])===0) {
        $data=array
        (
          "has_cdr"       	=>1,
          "tipo_estado"   	=>"05",
          "respuesta_sunat" =>$resultado['mensaje_sunat'],
          "qr"							=>$resultado['qr'],
        );
        $actualizar=$this->despacho_model->update($data,$id);

        //$reimpresion=base_url()."venta/pdfguia/".$id;
      }else{
        $data=array
        (
          "has_cdr"       	=>1,
          "tipo_estado"   	=>"09",
          "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
        );
        $actualizar=$this->despacho_model->update($data,$id);
      }

      $this->session->set_flashdata('css', 'success');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    }
    //redirect(base_url().'venta/despacho');
    return $resultado['mensaje_sunat'];
	}

  public function resumenesi()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $listas=$this->venta_model->mostrarFechas(array("grupo"=>'02',"has_cdr"=>0,"tipo_estado"=>"01","rectificar"=>0));
    $this->layout->setTitle('Resumenes no Enviado');
    $this->layout->view('resumenesi',compact("establecimientos","nestablecimiento",'empresa','listas'));
  }

  public function itemsResumen($id)
  {
    $detalles=$this->resumend_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      if ($detalle->idventa!='') {
        $documento=$this->venta_model->mostrar($detalle->idventa);
        $cliente=$this->cliente_model->mostrar(array("c.id"=>$documento->idcliente));
        $itemx=array
        (
          'idresumen'       =>$id,
          'tipo_comprobante'=>$documento->tcomprobante,
          'serie'           =>$documento->serie,
          'numero'          =>$documento->numero,
          'tipo_documento'  =>$cliente->tdocumento,
          'documento'       =>$cliente->documento,
          'condicion'       =>$detalle->condicion,
          'moneda'          =>$documento->moneda,
          'total'           =>$documento->total,
          'total_gravado'   =>$documento->tgravado,
          'total_exonerado' =>$documento->texonerado,
          'total_inafecto'  =>$documento->tinafecto,
          'total_impuesto'  =>$documento->tigv,
          'total_igv'       =>$documento->tigv,
          'tipo_afectado'   =>'',
          'afectado'        =>'',
        );
      } else {
        $documento=$this->nota_model->mostrar($detalle->idnota);
        $cliente=$this->cliente_model->mostrar(array("c.id"=>$documento->idcliente));
        $venta=$this->venta_model->mostrar($documento->idventa);
        $itemx=array
        (
          'idresumen'       =>$id,
          'tipo_comprobante'=>$documento->tcomprobante,
          'serie'           =>$documento->serie,
          'numero'          =>$documento->numero,
          'tipo_documento'  =>$cliente->tdocumento,
          'documento'       =>$cliente->documento,
          'condicion'       =>$detalle->condicion,
          'moneda'          =>$documento->moneda,
          'total'           =>$documento->total,
          'total_gravado'   =>$documento->tgravado,
          'total_exonerado' =>$documento->texonerado,
          'total_inafecto'  =>$documento->tinafecto,
          'total_impuesto'  =>$documento->tigv,
          'total_igv'       =>$documento->tigv,
          'tipo_afectado'   =>$venta->tcomprobante,
          'afectado'        =>$venta->serie.'-'.$venta->numero,
        );
      }

      $datos[]=$itemx;
    }
    return $datos;
  }

  public function enviarResumen($fecha)
  {
    $empresa=$this->empresa_model->mostrar();
    $ventas=$this->venta_model->mostrarTotal(array("grupo"=>'02',"tipo_estado"=>"01",'femision'=>$fecha),"asc");
    $notas=$this->nota_model->mostrarTotal(array("grupo"=>'02',"tipo_estado"=>"01",'femision'=>$fecha),"asc");
    if ($ventas!=NULL || $notas!=NULL) {
      $numeracion = $this->resumen_model->mostrar(array("femision"=>date("Y-m-d")));
      $separador = $numeracion==null ? '' : explode('-',$numeracion->identificador);
      $numero = $numeracion==null ? 1: $separador[2]+1;
      $codigo = str_replace('-','',date("Y-m-d"));

      $comprobante=array
      (
        'idestablecimiento' =>$this->session->userdata("predeterminado"),
        'tipo_soap'         =>$empresa->tipo_soap,
        'iduser'            =>$this->session->userdata('id'),
        'femision'          =>date("Y-m-d"),
        'fdocumento'        =>$fecha,
        'tproceso'          =>1,
        'identificador'     =>'RC-'.$codigo.'-'.$numero,
        "tipo_estado"       =>"01",
      );
      $insertar=$this->resumen_model->insert($comprobante);

      foreach ($ventas as $interno) {
        $datad=array
        (
          'idresumen' =>$insertar,
          'idventa'   =>$interno->id,
          'condicion' =>1
        );
        $insertard=$this->resumend_model->insert($datad);

        $datav=array("tipo_estado"=>"03");
        $actualizarv=$this->venta_model->update($datav,$interno->id);
      }

      foreach ($notas as $interno) {
        $datad=array
        (
          'idresumen' =>$insertar,
          'idnota'    =>$interno->id,
          'condicion' =>1
        );
        $insertard=$this->resumend_model->insert($datad);

        $datav=array("tipo_estado"=>"03");
        $actualizarv=$this->nota_model->update($datav,$interno->id);
      }

      $nombrexml = $empresa->ruc.'-RC-'.$codigo.'-'.$numero;
      $ruta_xml = "downloads/xml/".$nombrexml;
      $detalle=$this->itemsResumen($insertar);
      $this->generadoXML->CrearXMLResumenDocumentos($ruta_xml, $empresa, $comprobante, $detalle);

      $ruta_certificado = "downloads/certificado/".$empresa->certificado;
      $hash = $this->firmadoXML->FirmarDocumento($ruta_xml,$ruta_certificado,$empresa->certificado_clave);
      $resultado = $this->apiFacturacion->EnviarResumenComprobantes($empresa,$nombrexml,$ruta_xml);

      if ($resultado['ticket']!='') {
        $datav=array
        (
          'filename'  =>$nombrexml,
          'ticket'    =>$resultado['ticket'],
          'has_xml'   =>1,
        );
        $actualizar=$this->resumen_model->update($datav,$insertar);

        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
      }else{
        $this->session->set_flashdata('css', 'danger');
        $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
      }
    } else {
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', 'No hay documentos para la fecha '.$fecha);
    }

    redirect(base_url().'facturacion/resumenesi');
  }

  public function anulacionesi()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $listas=$this->venta_model->mostrarFechas(array("tcomprobante"=>'01',"tipo_estado<"=>'11',"nulo"=>1));
    $this->layout->setTitle('Anulaciones no Enviado');
    $this->layout->view('anulacionesi',compact("establecimientos","nestablecimiento",'empresa','listas'));
  }

  public function itemsAnulado($id)
  {
    $detalles=$this->anuladod_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      $documento=$this->venta_model->mostrar($detalle->idventa);
      $itemx=array
      (
        'idanulado'       =>$id,
        'tcomprobante'    =>$documento->tcomprobante,
        'serie'           =>$documento->serie,
        'numero'          =>$documento->numero,
        'motivo'          =>$detalle->motivo,
      );

      $datos[]=$itemx;
    }
    return $datos;
  }

  public function enviarAnulado($fecha)
  {
    $empresa=$this->empresa_model->mostrar();
    $ventas=$this->venta_model->mostrarTotal(array('femision'=>$fecha,"tcomprobante"=>'01',"tipo_estado<"=>'11',"nulo"=>1),"asc");
    if ($ventas!=NULL) {
      $numeracion = $this->anulado_model->mostrar(array("femision"=>date("Y-m-d")));
      $separador = $numeracion==null ? '' : explode('-',$numeracion->identificador);
      $numero = $numeracion==null ? 1: $separador[2]+1;
      $codigo = str_replace('-','',date("Y-m-d"));

      $comprobante=array
      (
        'idestablecimiento' =>$this->session->userdata("predeterminado"),
        'tipo_soap'         =>$empresa->tipo_soap,
        'iduser'            =>$this->session->userdata('id'),
        'femision'          =>date("Y-m-d"),
        'fdocumento'        =>$fecha,
        'identificador'     =>'RA-'.$codigo.'-'.$numero,
        "tipo_estado"       =>"01",
      );
      $insertar=$this->anulado_model->insert($comprobante);

      foreach ($ventas as $interno) {
        $datad=array
        (
          'idanulado' =>$insertar,
          'idventa'   =>$interno->id,
          'motivo'    =>'Anulacion de Operacion'
        );
        $insertard=$this->anuladod_model->insert($datad);

        $datav=array("tipo_estado"=>"13");
        $actualizarv=$this->venta_model->update($datav,$interno->id);
      }

      $nombrexml = $empresa->ruc.'-RA-'.$codigo.'-'.$numero;
      $ruta_xml = "downloads/xml/".$nombrexml;
      $detalle=$this->itemsAnulado($insertar);
      $this->generadoXML->CrearXmlBajaDocumentos($ruta_xml, $empresa, $comprobante, $detalle);

      $ruta_certificado = "downloads/certificado/".$empresa->certificado;
      $hash = $this->firmadoXML->FirmarDocumento($ruta_xml,$ruta_certificado,$empresa->certificado_clave);
      $resultado = $this->apiFacturacion->EnviarResumenComprobantes($empresa,$nombrexml,$ruta_xml);

      if ($resultado['ticket']!='') {
        $datav=array
        (
          'filename'  =>$nombrexml,
          'ticket'    =>$resultado['ticket'],
          'has_xml'   =>1,
        );
        $actualizar=$this->anulado_model->update($datav,$insertar);

        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
      }else{
        $this->session->set_flashdata('css', 'danger');
        $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
      }
    } else {
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', 'No hay documentos para la fecha '.$fecha);
    }
    redirect(base_url().'facturacion/anulacionesi');
  }

  public function anulacionesb()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $listas=$this->venta_model->mostrarFechas(array("tcomprobante"=>'03',"tipo_estado<"=>'11',"nulo"=>1));
    $this->layout->setTitle('Anulaciones no Enviado');
    $this->layout->view('anulacionesb',compact("establecimientos","nestablecimiento",'empresa','listas'));
  }

  public function enviarAnuladob($fecha)
  {
    $empresa=$this->empresa_model->mostrar();
    $ventas=$this->venta_model->mostrarTotal(array('femision'=>$fecha,"tcomprobante"=>'03',"tipo_estado<"=>'11',"nulo"=>1),"asc");
    if ($ventas!=NULL) {
      $numeracion = $this->resumen_model->mostrar(array("femision"=>date("Y-m-d")));
      $separador = $numeracion==null ? '' : explode('-',$numeracion->identificador);
      $numero = $numeracion==null ? 1: $separador[2]+1;
      $codigo = str_replace('-','',date("Y-m-d"));

      $comprobante=array
      (
        'idestablecimiento' =>$this->session->userdata("predeterminado"),
        'tipo_soap'         =>$empresa->tipo_soap,
        'iduser'            =>$this->session->userdata('id'),
        'femision'          =>date("Y-m-d"),
        'fdocumento'        =>$fecha,
        'tproceso'          =>3,
        'identificador'     =>'RC-'.$codigo.'-'.$numero,
        "tipo_estado"       =>"01",
      );
      $insertar=$this->resumen_model->insert($comprobante);

      foreach ($ventas as $interno) {
        $datad=array
        (
          'idresumen' =>$insertar,
          'idventa'   =>$interno->id,
          'condicion' =>3
        );
        $insertard=$this->resumend_model->insert($datad);

        $datav=array("tipo_estado"=>"13");
        $actualizarv=$this->venta_model->update($datav,$interno->id);
      }

      $nombrexml = $empresa->ruc.'-RC-'.$codigo.'-'.$numero;
      $ruta_xml = "downloads/xml/".$nombrexml;
      $detalle=$this->itemsResumen($insertar);
      $this->generadoXML->CrearXMLResumenDocumentos($ruta_xml, $empresa, $comprobante, $detalle);

      $ruta_certificado = "downloads/certificado/".$empresa->certificado;
      $hash = $this->firmadoXML->FirmarDocumento($ruta_xml,$ruta_certificado,$empresa->certificado_clave);
      $resultado = $this->apiFacturacion->EnviarResumenComprobantes($empresa,$nombrexml,$ruta_xml);

      if ($resultado['ticket']!='') {
        $datav=array
        (
          'filename'  =>$nombrexml,
          'ticket'    =>$resultado['ticket'],
          'has_xml'   =>1,
        );
        $actualizar=$this->resumen_model->update($datav,$insertar);

        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
      }else{
        $this->session->set_flashdata('css', 'danger');
        $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
      }
    } else {
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', 'No hay documentos para la fecha '.$fecha);
    }
    redirect(base_url().'facturacion/anulacionesb');
  }

	/*=========================================================================================================================
	=                           rectificaciones                          =
	=========================================================================================================================*/
	public function rectificaciones()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$filtros=array("tipo_estado"=>"01","rectificar"=>1);
		$listas=$this->venta_model->mostrarTotal($filtros,"desc");
		$listasn=$this->nota_model->mostrarTotal($filtros,"desc");
		$this->layout->setTitle('Comprobante por rectificar');
		$this->layout->view('rectificaciones',compact("establecimientos","nestablecimiento",'listas','listasn','empresa'));
	}

  public function consultacdr($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->venta_model->mostrar($id);
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->consultarCdr($empresa,$datos->tcomprobante,$datos->serie,$datos->numero,$rutacdr);
    if (!is_numeric($resultado['codigo_sunat'])) {
      $this->session->set_flashdata('css', 'danger');
    } elseif (obtenerNumero($resultado['codigo_sunat'])===0) {
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"05",
        "respuesta_sunat" =>$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<2000) { //Del 0100 al 1999 Excepciones
      $data=array
      (
        "rectificar"   =>1,
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'info');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<'4000') { //Del 2000 al 3999 Errores que generan rechazo
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"09",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'info');
    } else {// 4000 en adelante Observaciones
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"07",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->venta_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    }

    $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    redirect(base_url().'facturacion/rectificaciones');
  }

	public function consultancdr($id)
	{
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->nota_model->mostrar($id);
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->consultarCdr($empresa,$datos->tcomprobante,$datos->serie,$datos->numero,$rutacdr);
    if (!is_numeric($resultado['codigo_sunat'])) {
      $this->session->set_flashdata('css', 'danger');
    } elseif (obtenerNumero($resultado['codigo_sunat'])===0) {
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"05",
        "respuesta_sunat" =>$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<2000) { //Del 0100 al 1999 Excepciones
      $data=array
      (
        "rectificar"   =>1,
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'info');
    } elseif (obtenerNumero($resultado['codigo_sunat'])<'4000') { //Del 2000 al 3999 Errores que generan rechazo
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"09",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'info');
    } else {// 4000 en adelante Observaciones
      $data=array
      (
        "has_cdr"       =>1,
        "tipo_estado"   =>"07",
        "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
      );
      $actualizar=$this->nota_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
    }

    $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    redirect(base_url().'facturacion/rectificaciones');
	}

	/*=========================================================================================================================
	=                    resumen diario de boletas                 =
	=========================================================================================================================*/
	public function resumenes()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date('Y-m-d')) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

		$filtros=array('femision>='=>$inicio,'femision<='=>$fin,"tproceso"=>1);
		$listas=$this->resumen_model->mostrarTotal($filtros);
		$this->layout->setTitle('Resumenes Boleta');
		$this->layout->view('resumenes',compact("establecimientos","nestablecimiento",'listas','inicio','fin','empresa'));
	}

  public function pendienter()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date('Y-m-d')) ;
    $fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

    $filtros=array('femision>='=>$inicio,'femision<='=>$fin,"tproceso"=>1,"tipo_estado"=>'01');
    $listas=$this->resumen_model->mostrarTotal($filtros);
    $this->layout->setTitle('Resumenes Boleta');
    $this->layout->view('pendienter',compact("establecimientos","nestablecimiento",'listas','inicio','fin','empresa'));
  }

  public function consultarResumen($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->resumen_model->mostrar(array("id"=>$id));
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->ConsultarTicket($empresa,$datos->filename,$datos->ticket,$rutacdr);

    if ($resultado['estado']!=2) {
      if (obtenerNumero($resultado['codigo_sunat'])===0) {
        $data=array
        (
          "has_cdr"       =>1,
          "tipo_estado"   =>"05",
          "respuesta_sunat" =>$resultado['mensaje_sunat'],
        );
        $actualizar=$this->resumen_model->update($data,$id);

        if ($datos->validado==0) {
          $consultas=$this->resumend_model->mostrarTotal($id);
          foreach ($consultas as $consulta) {
            if ($datos->tproceso=='01') {
            $datav=array("tipo_estado"=>'05');
            } else {
            $datav=array("tipo_estado"=>'11');
            }
            if ($consulta->idventa!='') {
              $actualizar=$this->venta_model->update($datav,$consulta->idventa);
            } else {
              $actualizar=$this->nota_model->update($datav,$consulta->idnota);
            }
          }
        }
      }else{
        $data=array
        (
          "has_cdr"       =>1,
          "tipo_estado"   =>"09",
          "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
        );
        $actualizar=$this->resumen_model->update($data,$id);

        //liberar ventas
        $detalles=$this->resumend_model->mostrarTotal($id);
        foreach ($detalles as $detalle) {
          if ($datos->tproceso=='01') {
            $datav=array("tipo_estado"=>"01");
          } else {
            $datav=array("tipo_estado"=>"05");
          }

          if ($detalle->idventa!="") {
            $actualizarv=$this->venta_model->update($datav,$detalle->idventa);
          } else {
            $actualizarv=$this->nota_model->update($datav,$detalle->idnota);
          }
        }
      }

      $this->session->set_flashdata('css', 'success');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    } else {
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    }

    if ($datos->tproceso=='01') {
      redirect(base_url().'facturacion/resumenes');
    }else{
      redirect(base_url().'facturacion/anulaciones');
    }
  }

	public function eliminarr($id)
	{
		if (!$id) {show_404();}
		$datos=$this->resumen_model->mostrar(array("id"=>$id));
		if ($datos==NULL) {show_404();}

		$empresa=$this->empresa_model->mostrar();
		$detalles=$this->resumend_model->mostrarTotal($id);
		foreach ($detalles as $detalle) {
			$datav=array("tipo_estado"=>"01");
			if ($detalle->idventa!="") {
				$actualizarv=$this->venta_model->update($datav,$detalle->idventa);
			} else {
				$actualizarv=$this->nota_model->update($datav,$detalle->idnota);
			}
		}

		$eliminarr=$this->resumen_model->delete($id);
		$eliminard=$this->resumend_model->delete($id);
		echo 'borrado';
	}

	/*===================================================================================================================
	=                                              anulaciones de documentos                                            =
	===================================================================================================================*/
	public function anulaciones()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date('Y-m-d')) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

		$filtrosf=array('femision>='=>$inicio,'femision<='=>$fin);
		$listasf=$this->anulado_model->mostrarTotal($filtrosf);

		$filtrosb=array('femision>='=>$inicio,'femision<='=>$fin,"tproceso"=>3);
		$listasb=$this->resumen_model->mostrarTotal($filtrosb);
		$this->layout->setTitle('Anulaciones Venta');
		$this->layout->view('anulaciones',compact("establecimientos","nestablecimiento",'listasf','listasb','inicio','fin','empresa'));
	}

  public function pendientea()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date('Y-m-d')) ;
    $fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

    $filtrosf=array('femision>='=>$inicio,'femision<='=>$fin,"tipo_estado"=>'01');
    $listasf=$this->anulado_model->mostrarTotal($filtrosf);

    $filtrosb=array('femision>='=>$inicio,'femision<='=>$fin,"tproceso"=>3,"tipo_estado"=>'01');
    $listasb=$this->resumen_model->mostrarTotal($filtrosb);
    $this->layout->setTitle('Anulaciones Venta');
    $this->layout->view('pendientea',compact("establecimientos","nestablecimiento",'listasf','listasb','inicio','fin','empresa'));
  }

  public function consultarBaja($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->anulado_model->mostrar(array("id"=>$id));
    $rutacdr="downloads/cdr/";
    $resultado = $this->apiFacturacion->ConsultarTicket($empresa,$datos->filename,$datos->ticket,$rutacdr);

    if ($resultado['estado']!=2) {
      if (obtenerNumero($resultado['codigo_sunat'])===0) {
        $data=array
        (
          "has_cdr"       =>1,
          "tipo_estado"   =>"05",
          "respuesta_sunat" =>$resultado['mensaje_sunat'],
        );
        $actualizar=$this->anulado_model->update($data,$id);

        if ($datos->validado==0) {
          $consultas=$this->anuladod_model->mostrarTotal($id);
          foreach ($consultas as $consulta) {
            $datav=array("tipo_estado"=>11);
            $actualizar=$this->venta_model->update($datav,$consulta->idventa);
          }
        }
      }else{
        $data=array
        (
          "has_cdr"       =>1,
          "tipo_estado"   =>"09",
          "respuesta_sunat" =>$resultado['codigo_sunat'].' '.$resultado['mensaje_sunat'],
        );
        $actualizar=$this->anulado_model->update($data,$id);

        //liberar ventas
        $detalles=$this->anuladod_model->mostrarTotal($id);
        foreach ($detalles as $detalle) {
          $datav=array("tipo_estado"=>"05");
          if ($detalle->idventa!='') {
            $actualizarv=$this->venta_model->update($datav,$detalle->idventa);
          } else {
            $actualizarv=$this->nota_model->update($datav,$detalle->idnota);
          }
        }
      }

      $this->session->set_flashdata('css', 'success');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    } else {
      $this->session->set_flashdata('css', 'danger');
      $this->session->set_flashdata('mensaje', $resultado['mensaje_sunat']);
    }
    redirect(base_url().'facturacion/anulaciones');
  }

  public function eliminara($id)
  {
    if (!$id) {show_404();}
    $datos=$this->anulado_model->mostrar(array("id"=>$id));
    if ($datos==NULL) {show_404();}

    $detalles=$this->anuladod_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      $datav=array("tipo_estado"=>"05");
      if ($detalle->idventa!='') {
        $actualizarv=$this->venta_model->update($datav,$detalle->idventa);
      } else {
        $actualizarv=$this->nota_model->update($datav,$detalle->idnota);
      }
    }

    $eliminarr=$this->anulado_model->delete($id);
    $eliminard=$this->anuladod_model->delete($id);
    echo 'borrado';
  }

  public function eliminarb($id)
  {
    if (!$id) {show_404();}
    $datos=$this->resumen_model->mostrar(array("id"=>$id));
    if ($datos==NULL) {show_404();}

    $detalles=$this->resumend_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      $datav=array("tipo_estado"=>"05");
      if ($detalle->idventa!='') {
        $actualizarv=$this->venta_model->update($datav,$detalle->idventa);
      } else {
        $actualizarv=$this->nota_model->update($datav,$detalle->idnota);
      }
    }

    $eliminarr=$this->resumen_model->delete($id);
    $eliminard=$this->resumend_model->delete($id);
    echo 'borrado';
  }

	/*===================================================================================================================
	=                                              consistencia de documentos                                           =
	===================================================================================================================*/
	public function consistencia()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$listas=$this->serie_model->mostrarTotal(array("idestablecimiento"=>$this->session->userdata("predeterminado")));
		$this->layout->setTitle('Comprobante Emitido');
		$this->layout->view('consistencia',compact("establecimientos","nestablecimiento",'listas','empresa'));
	}

	/*===================================================================================================================
	=                                                    validaciones                                                   =
	===================================================================================================================*/
	public function busSerie()
	{
		if ($this->input->post())
		{
			$datos=$this->serie_model->mostrarTotal(array('tcomprobante'=>$this->input->post('nro',true)));
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function generarToken()
	{
		$empresa=$this->empresa_model->mostrar();
		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api-seguridad.sunat.gob.pe/v1/clientesextranet/'.$empresa->id_validador.'/oauth2/token/',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS => 'grant_type=client_credentials&scope=https://api.sunat.gob.pe/v1/contribuyente/contribuyentes&client_id='.$empresa->id_validador.'&client_secret='.$empresa->secret_validador.'',
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/x-www-form-urlencoded'
		  ),
		));

		$response = curl_exec($curl);
		curl_close($curl);
		return json_decode($response,true);
	}

	public function consultarValidez($tcomprobante,$serie,$numero,$femision,$monto)
	{
		$empresa=$this->empresa_model->mostrar();
		$data_json=array(
			"numRuc"=> $empresa->ruc,
			"codComp"=> $tcomprobante,
			"numeroSerie"=> $serie,
			"numero"=> $numero,
			"fechaEmision"=> $femision,
			"monto"=> $monto
		);
		$data_json=json_encode($data_json);

		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => "https://api.sunat.gob.pe/v1/contribuyente/contribuyentes/".$empresa->ruc."/validarcomprobante",
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS =>$data_json,
		  CURLOPT_HTTPHEADER => array(
		    "Content-Type: application/json",
		    "Authorization: Bearer ".$empresa->token_validador
		  ),
		));

		$response = curl_exec($curl);
		curl_close($curl);
		return json_decode($response,true);
	}

	public function validador()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$limite=fechaHoraria('+ '.$empresa->expires_validador.' second ',$empresa->fecha_validador);
		if (date("Y-m-d H:i:s")>=$limite) {
			$respuesta_json=self::generarToken();

			$data=array
			(
				'token_validador'	=>$respuesta_json["access_token"],
				'fecha_validador'	=>date("Y-m-d H:i:s"),
				'expires_validador'	=>$respuesta_json["expires_in"],
			);
			$actualizar=$this->empresa_model->update($data);
		}

		$comprobantec=$this->tcomprobante_model->mostrarLimite(array("formulario"=>1));
		$comprobanten=$this->tcomprobante_model->mostrarLimite(array("formulario"=>2));
		$nseries=$this->serie_model->mostrarTotal(array('tcomprobante'=>'03'));

		$listas=array();
		if ($this->input->post())
		{
			if ($this->input->post('comprobante',true)=='01' || $this->input->post('comprobante',true)=='03') {
				if ($this->input->post('fin',true)) {
					$filtros=array('serie'=>$this->input->post('serie',true),'numero>='=>$this->input->post('inicio',true),'numero<='=>$this->input->post('fin',true));
				} else {
					$filtros=array('serie'=>$this->input->post('serie',true),'numero'=>$this->input->post('inicio',true));
				}
				$datos=$this->venta_model->mostrarTotal($filtros,"asc");
			}else{
				if ($this->input->post('fin',true)) {
					$filtros=array('n.serie'=>$this->input->post('serie',true),'n.numero>='=>$this->input->post('inicio',true),'n.numero<='=>$this->input->post('fin',true));
				} else {
					$filtros=array('n.serie'=>$this->input->post('serie',true),'n.numero'=>$this->input->post('inicio',true));
				}
				$datos=$this->nota_model->mostrarTotal($filtros,"asc");
			}

			foreach ($datos as $dato) {
				$respuesta_json=self::consultarValidez($dato->tcomprobante,$dato->serie,$dato->numero,FormatoFecha($dato->femision),$dato->total);
				//var_dump($respuesta_json);
				if ($respuesta_json["data"]==NULL) {
					break;
				}

				$estados=$this->tvalidacion_model->mostrar(array("tipo"=>"E","id"=>$respuesta_json["data"]["estadoCp"]));
				if($respuesta_json["data"]["estadoCp"] == 1){
					$badges='badge-success';
				}else if($respuesta_json["data"]["estadoCp"] == 2){
					$badges='badge-danger';
				}else{
					$badges='badge-primary';
				}
				$estadod=$this->testado_model->mostrar($dato->tipo_estado);

				$anexos['id']=$dato->id;
				$anexos['ncomprobante']=$dato->ncomprobante;
				$anexos['serie']=$dato->serie;
				$anexos['numero']=$dato->numero;
				$anexos['femision']=$dato->femision;
				$anexos['cliente']=$dato->cliente;
				$anexos['badged']=$estadod->badge;
				$anexos['estadod']=$estadod->descripcion;
				$anexos['badges']=$badges;
				$anexos['estados']=$estados->descripcion;
				$anexos['estadocp']=$respuesta_json["data"]["estadoCp"];
				array_push($listas,$anexos);
			}
		}
		$this->layout->setTitle('Validador Documentos');
		$this->layout->view('validador',compact("establecimientos","nestablecimiento",'empresa','comprobantec','comprobanten','nseries','listas'));
	}

  public function regularizar()
  {
    if ($this->input->post())
    {
      for ($i=0; $i < count($this->input->post('id',true)) ; $i++) {
        if ($this->input->post('estadocp',true)[$i]==1) {
          if ($this->input->post('tipo',true)=='01' || $this->input->post('tipo',true)=='03') {
            $data=array
            (
              'tipo_estado'   =>'05',
              'respuesta_sunat'  =>0,
            );
            $actualizar=$this->venta_model->update($data,$this->input->post('id',true)[$i]);
          }elseif($this->input->post('tipo',true)=='07' || $this->input->post('tipo',true)=='08'){
            $datos=$this->nota_model->mostrar($this->input->post('id',true)[$i]);
            $data=array
            (
              'tipo_estado'   =>'05',
              'respuesta_sunat'  =>0,
            );
            $actualizar=$this->nota_model->update($data,$this->input->post('id',true)[$i]);
          }
        }elseif ($this->input->post('estadocp',true)[$i]==2) {
          if ($this->input->post('tipo',true)=='01' || $this->input->post('tipo',true)=='03') {
            $data=array("tipo_estado"=>"11");
            $actualizar=$this->venta_model->update($data,$this->input->post('id',true)[$i]);
          }elseif($this->input->post('tipo',true)=='07' || $this->input->post('tipo',true)=='08'){
            $data=array("tipo_estado"=>"11");
            $actualizar=$this->nota_model->update($data,$this->input->post('id',true)[$i]);
          }
        }
      }
      redirect(base_url()."facturacion/validador");
    }
  }

	public function validadorb()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$limite=fechaHoraria('+ '.$empresa->expires_validador.' second ',$empresa->fecha_validador);
		if (date("Y-m-d H:i:s")>=$limite) {
			$respuesta_json=self::generarToken();

			$data=array
			(
				'token_validador'	=>$respuesta_json["access_token"],
				'fecha_validador'	=>date("Y-m-d H:i:s"),
				'expires_validador'	=>$respuesta_json["expires_in"],
			);
			$actualizar=$this->empresa_model->mostrarUpdate($data);
		}

		$listas=array();
		$datos=array();
		if ($this->input->post())
		{
			$datos=$this->resumen_model->mostrar(array("ticket"=>$this->input->post('ticket',true)));
			$detalles=$this->resumend_model->mostrarTotal($datos->id);
			foreach ($detalles as $detalle) {
				if ($detalle->idventa!="") {
					$dato=$this->venta_model->mostrar($detalle->idventa);
				} else {
					$dato=$this->nota_model->mostrar($detalle->idnota);
				}
				$respuesta_json=self::consultarValidez($dato->tcomprobante,$dato->serie,$dato->numero,FormatoFecha($dato->femision),$dato->total);
				//var_dump($respuesta_json);
				if ($respuesta_json["data"]==NULL) {
					break;
				}
				$estados=$this->tvalidacion_model->mostrar(array("tipo"=>"E","id"=>$respuesta_json["data"]["estadoCp"]));

				if($respuesta_json["data"]["estadoCp"] == 1){
					$badges='badge-success';
				}elseif($respuesta_json["data"]["estadoCp"] == 2){
					$badges='badge-danger';
				}else{
					$badges='badge-primary';
				}
				$estadod=$this->testado_model->mostrar($dato->tipo_estado);

				$anexos['id']=$dato->id;
				$anexos['tipo']=$dato->tcomprobante;
				$anexos['ncomprobante']=$dato->ncomprobante;
				$anexos['serie']=$dato->serie;
				$anexos['numero']=$dato->numero;
				$anexos['femision']=$dato->femision;
				$anexos['cliente']=$dato->cliente;
				$anexos['estadod']=$estadod->descripcion;
				$anexos['badges']=$badges;
				$anexos['estados']=$estados->descripcion;
				$anexos['estadocp']=$respuesta_json["data"]["estadoCp"];
				array_push($listas,$anexos);
			}
		}
		$this->layout->setTitle('Validador Resumenes');
		$this->layout->view('validadorb',compact("establecimientos","nestablecimiento",'empresa','listas',"datos"));
	}

  public function regularizarb()
  {
    if ($this->input->post())
    {
      $nro=0; $nra=0;
      for ($i=0; $i < count($this->input->post('id',true)) ; $i++) {
        if ($this->input->post('estadocp',true)[$i]==1) {
          $data=array('tipo_estado' =>'05','respuesta_sunat'=>0);
          if ($this->input->post('tipo',true)[$i]=='03') {
            $actualizar=$this->venta_model->update($data,$this->input->post('id',true)[$i]);
          }elseif($this->input->post('tipo',true)[$i]=='07' || $this->input->post('tipo',true)[$i]=='08'){
            $actualizar=$this->nota_model->update($data,$this->input->post('id',true)[$i]);
          }
          $nro++;
        }elseif ($this->input->post('estadocp',true)[$i]==2) {
          $data=array('nulo'=>1, "tipo_estado"  =>"11");
          if ($this->input->post('tipo',true)[$i]=='03') {
            $actualizar=$this->venta_model->update($data,$this->input->post('id',true)[$i]);
          }elseif($this->input->post('tipo',true)[$i]=='07' || $this->input->post('tipo',true)[$i]=='08'){
            $actualizar=$this->nota_model->update($data,$this->input->post('id',true)[$i]);
          }
          $nra++;
        }
      }

      if ($nro>0 || $nra>0) {
        $empresa=$this->empresa_model->mostrar();
        $datos=$this->resumen_model->mostrar(array("id"=>$this->input->post('idresumen',true)));
        $datac=array('validado'=>1);
        $actualizarr=$this->resumen_model->update($datac,$this->input->post('idresumen',true));
      }
      redirect(base_url()."facturacion/validadorb");
    }
  }

	public function validadora()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$limite=fechaHoraria('+ '.$empresa->expires_validador.' second ',$empresa->fecha_validador);
		if (date("Y-m-d H:i:s")>=$limite) {
			$respuesta_json=self::generarToken();

			$data=array
			(
				'token_validador'	=>$respuesta_json["access_token"],
				'fecha_validador'	=>date("Y-m-d H:i:s"),
				'expires_validador'	=>$respuesta_json["expires_in"],
			);
			$actualizar=$this->empresa_model->mostrarUpdate($data);
		}

		$listas=array();
		$datos=array();
		if ($this->input->post())
		{
			$datos=$this->anulado_model->mostrar(array("ticket"=>$this->input->post('ticket',true)));
			if ($datos->idventa!="") {
				$dato=$this->venta_model->mostrar($datos->idventa);
			} else {
				$dato=$this->nota_model->mostrar($datos->idnota);
			}

			$respuesta_json=self::consultarValidez($dato->tcomprobante,$dato->serie,$dato->numero,FormatoFecha($dato->femision),$dato->total);
			//var_dump($respuesta_json);
			if ($respuesta_json["data"]!=NULL) {
				$estados=$this->tvalidacion_model->mostrar(array("tipo"=>"E","id"=>$respuesta_json["data"]["estadoCp"]));

				if($respuesta_json["data"]["estadoCp"] == 1){
					$badges='badge-success';
				}elseif($respuesta_json["data"]["estadoCp"] == 2){
					$badges='badge-danger';
				}else{
					$badges='badge-primary';
				}
				$estadod=$this->testado_model->mostrar($dato->tipo_estado);

				$anexos['id']=$dato->id;
				$anexos['tipo']=$dato->tcomprobante;
				$anexos['ncomprobante']=$dato->ncomprobante;
				$anexos['serie']=$dato->serie;
				$anexos['numero']=$dato->numero;
				$anexos['femision']=$dato->femision;
				$anexos['cliente']=$dato->cliente;
				$anexos['estadod']=$estadod->descripcion;
				$anexos['badges']=$badges;
				$anexos['estados']=$estados->descripcion;
				$anexos['estadocp']=$respuesta_json["data"]["estadoCp"];
				array_push($listas,$anexos);
			}
		}
		$this->layout->setTitle('Validador Anulaciones');
		$this->layout->view('validadora',compact("establecimientos","nestablecimiento",'empresa','listas',"datos"));
	}

  public function regularizara()
  {
    if ($this->input->post())
    {
      $nra=0;
      for ($i=0; $i < count($this->input->post('id',true)) ; $i++) {
        if ($this->input->post('estadocp',true)[$i]==2) {
          $data=array('nulo'=>1, "tipo_estado"=>"11");
          if ($this->input->post('tipo',true)[$i]=='01') {
            $actualizar=$this->venta_model->update($data,$this->input->post('id',true)[$i]);
          }elseif($this->input->post('tipo',true)[$i]=='07' || $this->input->post('tipo',true)[$i]=='08'){
            $actualizar=$this->nota_model->update($data,$this->input->post('id',true)[$i]);
          }
          $nra++;
        }
      }

      if ($nra>0) {
        $empresa=$this->empresa_model->mostrar();
        $datos=$this->anulado_model->mostrar(array("id"=>$this->input->post('idresumen',true)));
        $datac=array('validado'=>1);
        $actualizarr=$this->anulado_model->update($datac,$this->input->post('idresumen',true));
      }
      redirect(base_url()."facturacion/validadora");
    }
  }

}
