<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Ingreso extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("tpago_model");
    $this->load->model("tingreso_model");
    $this->load->model("ingreso_model");
    $this->load->library("mytcpdf");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date("Y-m-d")) ;
    $fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;

    if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
    $listas=$this->ingreso_model->mostrarTotal($filtros);
    $this->layout->setTitle("Ingresos");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin"));
  }

  public function ingresoi()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->input->post())
    {
      $data=array
      (
        'idestablecimiento' =>$this->session->userdata("predeterminado"),
        "iduser"            =>$this->session->userdata('id'),
        "femision"          =>$this->input->post("fecha",true),
        "comprobante"       =>$this->input->post("comprobante",true),
        "numero"            =>$this->input->post("numero",true),
        "idcliente"         =>$this->input->post("idproveedor",true),
        "cliente"           =>$this->input->post("proveedor",true),
        "motivo"            =>$this->input->post("motivo",true),
        "total"             =>$this->input->post("importe",true),
        "idtpago"           =>$this->input->post("mpago",true),
      );
      $insertar=$this->ingreso_model->insert($data);

      $this->session->set_flashdata("css", "success");
      $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");

      redirect(base_url()."ingreso");
    }

    $comprobantes=$this->tingreso_model->mostrarTotal();
    $mpagos=$this->tpago_model->mostrarTotal();
    $this->layout->setTitle("Ingreso");
    $this->layout->view("ingresoi",compact("establecimientos","nestablecimiento","mpagos","comprobantes"));
  }

  public function ingresod($id)
  {
    if (!$id) {show_404();}
    $datos=$this->ingreso_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    $eliminar=$this->ingreso_model->delete($id);
    echo 'borrado';
  }

  public function pdfingreso($inicio,$fin)
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
    $empresa=$this->empresa_model->mostrar();
    if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
    $listas=$this->ingreso_model->mostrarTotal($filtros);
    $this->layout->setLayout("blanco");
    $this->layout->view("pdfingreso",compact("empresa","nestablecimiento","listas","inicio","fin"));
  }

  public function excelingreso($inicio,$fin)
  {
    if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
    $listas=$this->ingreso_model->mostrarTotal($filtros);

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle("ingreso");

    $styleArray = [
        'borders' => [
            'top' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            ],
            'bottom' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            ],
            'left' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            ],
            'right' => [
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            ],
        ],
    ];

    foreach(range("A","F") as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
        $sheet->getStyle($columnID."1")->applyFromArray($styleArray);
    }

    $sheet->setCellValueByColumnAndRow(1, 1,"Id");
    $sheet->setCellValueByColumnAndRow(2, 1,"Fecha");
    $sheet->setCellValueByColumnAndRow(3, 1,"Cliente");
    $sheet->setCellValueByColumnAndRow(4, 1,"Numero");
    $sheet->setCellValueByColumnAndRow(5, 1,"Motivo");
    $sheet->setCellValueByColumnAndRow(6, 1,"Importe");

    $i=2; $j=1;
    foreach ($listas as $lista) {
      $sheet->getStyle("A".$i)->applyFromArray($styleArray);
      $sheet->getStyle("B".$i)->applyFromArray($styleArray);
      $sheet->getStyle("C".$i)->applyFromArray($styleArray);
      $sheet->getStyle("D".$i)->applyFromArray($styleArray);
      $sheet->getStyle("E".$i)->applyFromArray($styleArray);
      $sheet->getStyle("F".$i)->applyFromArray($styleArray);

      $sheet->setCellValue("A".$i,$j);
      $sheet->setCellValue("B".$i,$lista->femision);
      $sheet->setCellValue("C".$i,$lista->cliente);
      $sheet->setCellValue("D".$i,$lista->numero);
      $sheet->setCellValue("E".$i,$lista->motivo);
      $sheet->setCellValue("F".$i,$lista->total);
      $i++; $j++;
    }

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="LISTA_INGRESOS.xlsx"');
    $writer->save('php://output');  // download file
  }




}
