<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->layout->setLayout('login');
	}

	public function index()
	{
		if ($this->session->userdata('login')) {
			redirect(base_url('inicio'));
		}
		else{
			$this->layout->view('index');
		}
	}

	public function acceso()
	{
		if($this->input->post())
		{
			$datos=$this->usuario_model->login($this->input->post('usuario',true),$this->input->post('clave',true));
			if($datos==NULL)
			{
				$this->session->set_flashdata('css', 'danger');
				$this->session->set_flashdata('mensaje', 'El usuario y/o contraseña son incorrectos');
				redirect(base_url());
			}else
			{
				$empresa=$this->empresa_model->mostrar();
				if ($empresa->time!='') {
					//echo $empresa->time; exit();
					if ($empresa->time>=time()) {
						$data = array(
							'id' 								=> $datos->id,
							'nombre' 						=> $datos->nombres,
							'user' 							=> $datos->usuario,
							'tipo' 							=> $datos->tipo,
							'establecimientos' 	=> $datos->idestablecimiento,
							'predeterminado' 		=> $datos->predeterminadoe,
							'login' 						=> TRUE
						);
						$this->session->set_userdata($data);
						redirect(base_url('inicio'));
					} else {
						$this->session->set_flashdata('css', 'danger');
						$this->session->set_flashdata('mensaje', 'La vigencia del sistema ya caduco');
						redirect(base_url());
					}
				}else{
					$data = array(
						'id' 								=> $datos->id,
						'nombre' 						=> $datos->nombres,
						'user' 							=> $datos->usuario,
						'tipo' 							=> $datos->tipo,
						'establecimientos' 	=> $datos->idestablecimiento,
						'predeterminado' 		=> $datos->predeterminadoe,
						'login' 						=> TRUE
					);
					$this->session->set_userdata($data);
					redirect(base_url('inicio'));
				}
			}
		}
	}

	public function logout()
	{
		$this->session->sess_destroy();
		redirect(base_url());
	}
}
