<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Movimiento extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("tmovimiento_model");
    $this->load->model("kardex_model");
    $this->load->model("lote_model");
    $this->load->model("movimiento_model");
    $this->load->model("movimientod_model");
    $this->load->library("mytcpdf");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $inicio=$this->input->post("inicio",true)!=null ? $this->input->post("inicio",true) : SumarFecha("-15 day",date("Y-m-d")) ;
    $fin=$this->input->post("fin",true)!=null ? $this->input->post("fin",true) : date("Y-m-d");

    $filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);
    $listas=$this->movimiento_model->mostrarTotal($filtros);
    $this->layout->setTitle("Movimiento Producto");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin"));
  }

  public function ingreso()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $motivos=$this->tmovimiento_model->mostrarTotal(array("tipo"=>"I","estado"=>1));
    $this->layout->setTitle("Ingreso Producto");
    $this->layout->view("ingreso",compact("establecimientos","nestablecimiento","motivos"));
  }

  public function salida()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $motivos=$this->tmovimiento_model->mostrarTotal(array("tipo"=>"S","estado"=>1));
    $this->layout->setTitle("Salida Producto");
    $this->layout->view("salida",compact("establecimientos","nestablecimiento","motivos"));
  }

  public function ingresog()
  {
    if ($this->input->post())
    {
      $url='';
      if ($this->input->post('idproducto',true)==null) {
        $mensaje='No envio productos en el movimiento!';
      } else {
        $mtraslado=explode('-',$this->input->post('motivo',true));
        $data=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          "iduser"            =>$this->session->userdata('id'),
          "femision"          =>date("Y-m-d"),
          "idtmovimiento"     =>$mtraslado[0],
          "observaciones"     =>$this->input->post('observaciones',true),
        );
        $insertar=$this->movimiento_model->insert($data);

        $importe=0;
        for ($i=0; $i < count($this->input->post('idproducto',true)) ; $i++) {
          $saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post('idproducto',true)[$i]);
          $inicalf=$saldos==null ? 0: $saldos->saldof;
          $inicalv=$saldos==null ? 0: $saldos->saldov;

          $saldof=$inicalf+$this->input->post('almacenc',true)[$i];
          $saldov=$inicalv+$this->input->post('importe',true)[$i];
          $datak=array
          (
            'idestablecimiento' =>$this->session->userdata("predeterminado"),
            'iduser'            =>$this->session->userdata('id'),
            'fecha'             =>date("Y-m-d"),
            'idtmovimiento'     =>$mtraslado[0],
            'concepto'          =>$mtraslado[1],
            'idproducto'        =>$this->input->post('idproducto',true)[$i],
            'descripcion'       =>trim($this->input->post('descripcion',true)[$i]),
            'entradaf'          =>$this->input->post('almacenc',true)[$i],
            'saldof'            =>$saldof,
            'costo'             =>$this->input->post('almacenp',true)[$i],
            'entradav'          =>$this->input->post('importe',true)[$i],
            'saldov'            =>$saldov,
            'documento'         =>'MV-'.$insertar,
          );
          $insertark=$this->kardex_model->insert($datak);

          $datas=array('stock'=>$saldof);
          $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i]));

          if ($this->input->post('lote',true)[$i]!="") {
            $consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i],"nlote"=>$this->input->post('lote',true)[$i]));

            if ($consultal==null) {
              $datal=array
              (
                'idestablecimiento' =>$this->session->userdata("predeterminado"),
                'idproducto'        =>$this->input->post('idproducto',true)[$i],
                'nlote'             =>$this->input->post('lote',true)[$i],
                'fvencimiento'      =>$this->input->post('fvencimiento',true)[$i],
                'inicial'           =>$this->input->post('almacenc',true)[$i],
                'stock'             =>$this->input->post('almacenc',true)[$i],
              );
              $insertarl=$this->lote_model->insert($datal);
            } else {
              $datal=array("stock"=>$consultal->stock+$this->input->post('almacenc',true)[$i]);
              $actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post('idproducto',true)[$i],$this->input->post('lote',true)[$i]);
            }
          }

          $datad=array
          (
            "idmovimiento"  =>$insertar,
            "idproducto"    =>$this->input->post("idproducto",true)[$i],
            "descripcion"   =>trim($this->input->post("descripcion",true)[$i]),
            "unidad"        =>$this->input->post("unidad",true)[$i],
            "cantidad"      =>$this->input->post("cantidad",true)[$i],
            "precio"        =>$this->input->post("precio",true)[$i],
            "importe"       =>$this->input->post("importe",true)[$i],
            "calmacen"      =>$this->input->post("almacenc",true)[$i],
            "palmacen"      =>$this->input->post("almacenp",true)[$i],
            "lote"          =>$this->input->post("lote",true)[$i],
            "fvencimiento"  =>valor_fecha($this->input->post("fvencimiento",true)[$i]),
          );
          $insertard=$this->movimientod_model->insert($datad);
          $importe+=$this->input->post('importe',true)[$i];
        }

        $datas=array("importe"=>$importe);
        $actualizars=$this->movimiento_model->update($datas,$insertar);

        $mensaje='Los datos se han guardado exitosamente!';
        $url=base_url().'movimiento';
      }

      $datos['mensaje']=$mensaje;
      $datos['url']=$url;
      echo json_encode($datos);
      exit();
    }
  }

  public function salidag()
  {
    if ($this->input->post())
    {
      $url='';
      if ($this->input->post('idproducto',true)==null) {
        $mensaje='No envio productos en el movimiento!';
      } else {
        $mtraslado=explode('-',$this->input->post('motivo',true));
        $data=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          "iduser"            =>$this->session->userdata('id'),
          "femision"          =>date("Y-m-d"),
          "idtmovimiento"     =>$mtraslado[0],
          "observaciones"     =>$this->input->post('observaciones',true),
        );
        $insertar=$this->movimiento_model->insert($data);

        $importe=0;
        for ($i=0; $i < count($this->input->post('idproducto',true)) ; $i++) {
          $saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post('idproducto',true)[$i]);
          $inicalf=$saldos==null ? 0: $saldos->saldof;
          $inicalv=$saldos==null ? 0: $saldos->saldov;
          //costos promedio
          $costo=round($inicalv/$inicalf,4);
          $salidav=$this->input->post('almacenc',true)[$i]*$costo;

          $saldof=$inicalf-$this->input->post('almacenc',true)[$i];
          $saldov=$inicalv-$salidav;
          $datak=array
          (
            'idestablecimiento' =>$this->session->userdata("predeterminado"),
            'iduser'            =>$this->session->userdata('id'),
            'fecha'             =>date("Y-m-d"),
            'idtmovimiento'     =>$mtraslado[0],
            'concepto'          =>$mtraslado[1],
            'idproducto'        =>$this->input->post('idproducto',true)[$i],
            'descripcion'       =>trim($this->input->post('descripcion',true)[$i]),
            'salidaf'           =>$this->input->post('almacenc',true)[$i],
            'saldof'            =>$saldof,
            'costo'             =>$costo,
            'salidav'           =>$salidav,
            'saldov'            =>$saldov,
            'documento'         =>'MV-'.$insertar,
          );
          $insertark=$this->kardex_model->insert($datak);

          $datas=array('stock'=>$saldof);
          $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i]));

          $nlotes='';
          $clotes='';
          $flotes='';
          if ($this->input->post('lote',true)[$i]!="") {
            $cantidad=$this->input->post('almacenc',true)[$i];
            $clotes=array();
            $flotes=array();
            $nlotes=explode(",",$this->input->post("lote",true)[$i]);
            for ($l=0; $l < count($nlotes) ; $l++) {
              $consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$nlotes[$l]));
              $ncantidad=$cantidad-$consultal->stock; //nueva cantidad
              $saldoc=$consultal->stock-$cantidad;  //saldo a guardar

              if ($saldoc>0) {
                $datal=array('stock'=>$saldoc);
                $actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$nlotes[$l]);
              } else {
                $elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$nlotes[$l]));
              }

              if ($consultal->stock<$cantidad) {
                $inicialf=$consultal->stock;
              } else {
                $inicialf=$cantidad;
              }

              array_push($clotes,$inicialf);
              array_push($flotes,$consultal->fvencimiento);
              $cantidad=$ncantidad;
            }

            $nlotes=implode("|", $nlotes);
            $clotes=implode("|", $clotes);
            $flotes=implode("|", $flotes);
          }

          $datad=array
          (
            "idmovimiento"=>$insertar,
            "idproducto"  =>$this->input->post("idproducto",true)[$i],
            "descripcion" =>trim($this->input->post("descripcion",true)[$i]),
            "unidad"      =>$this->input->post("unidad",true)[$i],
            "cantidad"    =>$this->input->post("cantidad",true)[$i],
            "precio"      =>$salidav/$this->input->post("cantidad",true)[$i],
            "importe"     =>$salidav,
            "calmacen"    =>$this->input->post("almacenc",true)[$i],
            "palmacen"    =>$costo,
            "lote"        =>$nlotes,
            "clote"       =>$clotes,
            "fvencimiento"=>$flotes,
          );
          $insertard=$this->movimientod_model->insert($datad);
          $importe+=$salidav;
        }

        $datai=array("importe"=>$importe);
        $actualizari=$this->movimiento_model->update($datai,$insertar);

        $mensaje='Los datos se han guardado exitosamente!';
        $url=base_url().'movimiento';
      }

      $datos['mensaje']=$mensaje;
      $datos['url']=$url;
      echo json_encode($datos);
      exit();
    }
  }

  public function ingresoa($id)
  {
    $datos=$this->movimiento_model->mostrar($id);
    if ($datos->nulo==0) {
      $detalles=$this->movimientod_model->mostrarTotal($id);
      foreach ($detalles as $detalle) {
        $saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
        $inicalf=$saldos==null ? 0: $saldos->saldof;
        $inicalv=$saldos==null ? 0: $saldos->saldov;

        $saldof=$inicalf-$detalle->calmacen;
        $saldov=$inicalv-$detalle->importe;
        $datak=array
        (
          'idestablecimiento' =>$datos->idestablecimiento,
          'iduser'            =>$this->session->userdata('id'),
          "fecha"             =>date("Y-m-d"),
          "idtmovimiento"     =>$datos->idtmovimiento,
          "concepto"          =>"Anulacion ".$datos->nmtraslado,
          "idproducto"        =>$detalle->idproducto,
          "descripcion"       =>$detalle->descripcion,
          "salidaf"           =>$detalle->calmacen,
          "saldof"            =>$saldof,
          "costo"             =>$detalle->palmacen,
          "salidav"           =>$detalle->importe,
          "saldov"            =>$saldov,
          "documento"         =>'MV-'.$datos->id,
        );
        $insertark=$this->kardex_model->insert($datak);

        $datas=array("stock"=>$saldof);
        $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

        if ($detalle->lote!='') {
          $consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$detalle->lote));

          if ($consultal->stock>$detalle->calmacen) {
            $datal=array("stock"=>$consultal->stock-$detalle->calmacen);
            $actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$detalle->lote);
          } else {
            $elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$detalle->lote));
          }
        }
      }

      $data=array
      (
        "nulo"    =>1,
        "importe" =>"0.00",
      );
      $actualiza=$this->movimiento_model->update($data,$id);
      echo "borrado";
    }else{
      echo "no borrado";
    }
  }

  public function salidaa($id)
  {
    $datos=$this->movimiento_model->mostrar($id);
    if ($datos->nulo==0) {
      $detalles=$this->movimientod_model->mostrarTotal($id);
      foreach ($detalles as $detalle) {
        $saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
        $inicalf=$saldos==null ? 0: $saldos->saldof;
        $inicalv=$saldos==null ? 0: $saldos->saldov;

        //costos promedio
        $salidav=$detalle->calmacen*$detalle->palmacen;

        $saldof=$inicalf+$detalle->calmacen;
        $saldov=$inicalv+$salidav;
        $datak=array
        (
          'idestablecimiento' =>$datos->idestablecimiento,
          'iduser'            =>$this->session->userdata('id'),
          "fecha"             =>date("Y-m-d"),
          "idtmovimiento"     =>$datos->idtmovimiento,
          "concepto"          =>"Anulacion ".$datos->nmtraslado,
          "idproducto"        =>$detalle->idproducto,
          "descripcion"       =>$detalle->descripcion,
          "entradaf"          =>$detalle->calmacen,
          "saldof"            =>$saldof,
          "costo"             =>$detalle->palmacen,
          "entradav"          =>$salidav,
          "saldov"            =>$saldov,
          "documento"         =>'MV-'.$datos->id,
        );
        //var_dump($datak);
        $insertark=$this->kardex_model->insert($datak);

        $datas=array("stock"=>$saldof);
        $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

        //devolucion de lotes
        if ($detalle->lote!='') {
          $nlote=explode("|",$detalle->lote);
          $flote=explode("|",$detalle->fvencimiento);
          $clote=explode("|",$detalle->clote);

          for ($l=0; $l < count($nlote) ; $l++) {
            $consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlote[$l]));

            if ($consultal==null) {
              $datal=array
              (
                'idestablecimiento' =>$datos->idestablecimiento,
                "idproducto"        =>$detalle->idproducto,
                "nlote"             =>$nlote[$l],
                "fvencimiento"      =>valor_fecha($flote[$l]),
                "inicial"           =>$clote[$l],
                "stock"             =>$clote[$l],
              );
              $insertarl=$this->lote_model->insert($datal);
            } else {
              $datal=array("stock"=>$consultal->stock+$clote[$l]);
              $actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$nlote[$l]);
            }
          }
        }
      }

      $data=array
      (
        "nulo"    =>1,
        "importe" =>"0.00",
      );
      $actualiza=$this->movimiento_model->update($data,$id);
      echo "borrado";
    }else{
      echo "no borrado";
    }
  }

  public function consulta($id)
  {
    $datos=$this->movimiento_model->mostrar($id);
    $detalles=$this->movimientod_model->mostrarTotal($id);
    $this->layout->setLayout("blanco");
    $this->layout->view("consulta",compact("datos","detalles"));
  }

  public function pdfmovimiento($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $datos=$this->movimiento_model->mostrar($id);
    $detalles=$this->movimientod_model->mostrarTotal($id);
    $this->layout->setLayout("blanco");
    $this->layout->view("pdfmovimiento",compact("empresa","nestablecimiento","datos","detalles"));
  }


}
