<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Nventa extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("serie_model");
		$this->load->model("tpago_model");
		$this->load->model("tidentidad_model");
		$this->load->model("departamento_model");
		$this->load->model("provincia_model");
		$this->load->model("distrito_model");
		$this->load->model("cliente_model");
		$this->load->model("tafectacion_model");
		$this->load->model("categoria_model");
		$this->load->model("laboratorio_model");
		$this->load->model("pactivo_model");
		$this->load->model("aterapeutica_model");
		$this->load->model("lote_model");
		$this->load->model("kardex_model");
		$this->load->model("bonificado_model");
		$this->load->model("arqueo_model");
		$this->load->model("nventa_model");
		$this->load->model("nventad_model");
		$this->load->model("cobro_model");
		$this->load->model('cotizacion_model');
		$this->load->model('cotizaciond_model');
		$this->load->model("punto_model");
		$this->load->model("clientep_model");
		$this->load->model("vale_model");
		$this->load->library('mytcpdf');
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date("Y-m-d")) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date("Y-m-d") ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->nventa_model->mostrarTotal($filtros,"desc");
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		$this->layout->setTitle("Nota de Venta");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin","arqueoc"));
	}

	public function arqueoi()
	{
		if ($this->input->post())
		{
			$data=array
			(
				'idestablecimiento'	=>$this->session->userdata("predeterminado"),
				'iduser'						=>$this->session->userdata('id'),
				'femision'					=>date("Y-m-d"),
				'finicial'					=>date("Y-m-d H:i:s"),
				'minicial'					=>$this->input->post('minicial',true),
				'estado'						=>1,
			);
			$insertar=$this->arqueo_model->insert($data);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");

			echo base_url()."nventa/nventai";
			exit();
		}

		$this->layout->setLayout("blanco");
		$this->layout->view("arqueoi");
	}

  public function busDatos($tipo,$numero)
  {
    if ($tipo==1) {
			$ruta="https://api.apis.net.pe/v1/dni?numero=".$numero;
		}else{
			$ruta="https://api.apis.net.pe/v1/ruc?numero=".$numero;
		}

		$curl = curl_init();
		curl_setopt_array($curl, array(
		  // para user api versión 1
		  CURLOPT_URL => $ruta,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => 0,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 2,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		));
		$response = curl_exec($curl);
		curl_close($curl);
    return $response;
  }

	public function clientei()
	{
		if ($this->input->post("documento",true))
		{
			$consulta= $this->input->post("tipo",true)==0 ? 0: $this->cliente_model->contador($this->input->post("documento",true));
			if ($consulta==0) {
				if ($this->input->post("tipo",true)==1 && strlen($this->input->post("documento",true))==8 || $this->input->post("tipo",true)==6 && strlen($this->input->post("documento",true))==11 || $this->input->post("tipo",true)==4 || $this->input->post("tipo",true)==7 || $this->input->post("tipo",true)==0) {
					$data=array
					(
						"tdocumento"	=>$this->input->post("tipo",true),
						"documento"		=>$this->input->post("documento",true),
						"nombres"		=>trim(mb_strtoupper($this->input->post('nombres',true), 'UTF-8')),
						"idpais"			=>"PE",
						"iddepartamento"	=>$this->input->post("departamento",true),
						"idprovincia"		=>$this->input->post("provincia",true),
						"iddistrito"		=>$this->input->post("distrito",true),
						"direccion"		=>$this->input->post("direccion",true),
						"telefono"		=>$this->input->post("telefono",true),
						"email"			=>$this->input->post("email",true),
					);

					$insertar=$this->cliente_model->insert($data);
					$datos['success'] = true;
					$datos['data'] = array("idcliente"=>$insertar,"tdocumento"	=>$this->input->post("tipo",true),"documento"		=>$this->input->post("documento",true),"cliente"=>$this->input->post("nombres",true),"puntos"=>'Puntos Acumulados : 0');
				} else {
					$datos['success'] = false;
					$datos['data'] = "El numero de documento en incoherente con el tipo de documento";
				}
			} else {
				$datos['success'] = false;
				$datos['data'] = "El numero de documento ya fue ingresado";
			}
			echo json_encode($datos);
			exit();
		}

		$identidades=$this->tidentidad_model->mostrarTotal();
		$clientes=json_decode($this->busDatos($this->input->post("identidad",true),$this->input->post("numero",true)));
    $departamentos=$this->departamento_model->mostrarTotal();
    $provincias=$this->provincia_model->mostrarTotal(substr($clientes->ubigeo??'',0,2));
    $distritos=$this->distrito_model->mostrarTotal(substr($clientes->ubigeo??'',0,4));
		$this->layout->setLayout("blanco");
		$this->layout->view("clientei",compact("departamentos","provincias","distritos","identidades","clientes"));
	}

	public function productoi()
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			$consulta=$this->producto_model->contador(array("descripcion"=>$this->input->post('descripcion',true),"idlaboratorio"=>$this->input->post('laboratorio',true)));
			if ($consulta==0 && $this->input->post('descripcion',true)!='') {
				$data=array
				(
					'tipo'					=>$this->input->post('tipo',true),
					'idcategoria'		=>$this->input->post('categoria',true),
					'descripcion'		=>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')),
					'idlaboratorio'	=>$this->input->post('laboratorio',true),
					'idpactivo'			=>$this->input->post('pactivo',true),
					'idaterapeutica'=>$this->input->post('aterapeutica',true),
					'codbarra'			=>$this->input->post('codbarra',true),
					'rsanitario'		=>$this->input->post('rsanitario',true),
					'mstock'				=>$this->input->post('mstock',true),
					'tafectacion'		=>$this->input->post('tafectacion',true),
					'pcompra'				=>$this->input->post('pcompra',true),
					'factor'				=>$this->input->post('factor',true),
					'compra'				=>$this->input->post('compra',true),
					'estado'				=>1,
					'lote'					=>valor_check($this->input->post('lote',true)),
				);
				if ($this->input->post('factor',true)>1) {
					$data['factorb']=$this->input->post('factorb',true);
				}
				if ($empresa->pestablecimiento==0) {
					$data['pventa']=$this->input->post('pventa',true);
					$data['venta']=$this->input->post('venta',true);
					$data['pblister']=$this->input->post('pblister',true);
				}
				$insertar=$this->producto_model->insert($data);

				$investablecimientos=$this->establecimiento_model->mostrarTotal();
				foreach ($investablecimientos as $investablecimiento) {
					$datae=array
					(
						'idestablecimiento'	=>$investablecimiento->id,
						'idproducto'				=>$insertar,
						'stock'							=>0,
					);
					if ($empresa->pestablecimiento==1) {
						$datae['pventa']=$this->input->post('pventa',true);
						$datae['venta']=$this->input->post('venta',true);
						$datae['pblister']=$this->input->post('pblister',true);
					}
					$insertark=$this->inventario_model->insert($datae);
				}

				if ($this->input->post('stock',true)>0) {
					$datak=array
					(
						'idestablecimiento'	=>$this->session->userdata("predeterminado"),
						'iduser'						=>$this->session->userdata('id'),
						'fecha'							=>date("Y-m-d"),
						"idtmovimiento"			=>16,
						'concepto'					=>"Stock inicial",
						'idproducto'				=>$insertar,
						'descripcion'				=>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')),
						'entradaf'					=>$this->input->post('stock',true),
						'saldof'						=>$this->input->post('stock',true),
						'costo'							=>$this->input->post('pcompra',true),
						'entradav'					=>$this->input->post('stock',true)*$this->input->post('pcompra',true),
						'saldov'						=>$this->input->post('stock',true)*$this->input->post('pcompra',true),
					);
					$insertark=$this->kardex_model->insert($datak);

					$datas=array('stock'=>$this->input->post('stock',true));
					$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$insertar));

					if (valor_check($this->input->post('lote',true))==1 && $this->input->post('clote',true)!="") {
						$datal=array
						(
							'idestablecimiento'	=>$this->session->userdata("predeterminado"),
							'idproducto'				=>$insertar,
							'nlote'							=>$this->input->post('clote',true),
							'fvencimiento'			=>valor_fecha($this->input->post('fvencimiento',true)),
							'inicial'						=>$this->input->post('stock',true),
							'stock'							=>$this->input->post('stock',true),
						);
						$insertarl=$this->lote_model->insert($datal);
					}
				}

				$datos['success'] = true;
				$datos['mensaje'] = "El registro del producto se genero con exito";
			} else {
				$datos['success'] = false;
				$datos['mensaje'] = "El producto ya fue registrado";
			}

			echo json_encode($datos);
			exit();
		}

		$categorias=$this->categoria_model->mostrarTotal();
		$laboratorios=$this->laboratorio_model->mostrarTotal();
		$pactivos=$this->pactivo_model->mostrarTotal();
		$aterapeuticas=$this->aterapeutica_model->mostrarTotal();
		$tafectaciones=$this->tafectacion_model->mostrarTotal();
		$this->layout->setLayout("blanco");
		$this->layout->view("productoi",compact("categorias","laboratorios","pactivos","aterapeuticas","tafectaciones"));
	}

	public function cotizacioni($id)
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$canexos=$this->establecimiento_model->contador();
		$mpagos=$this->tpago_model->mostrarTotal();
		$productos=$this->producto_model->mostrarLimite(array("estado"=>1));
		$nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"tcomprobante"=>"99"));
		$cotizacion=$this->cotizacion_model->mostrar($id);
		$detalles=$this->cotizaciond_model->mostrarTotal($id);
		$ncliente=$this->cliente_model->mostrar(array("c.id"=>$cotizacion->idcliente));
		$this->layout->setTitle("Nota de Venta");
		$this->layout->view("cotizacioni",compact("establecimientos","nestablecimiento","empresa","canexos","mpagos","nserie","productos","cotizacion","detalles","ncliente","id"));
	}

	public function nventai()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$canexos=$this->establecimiento_model->contador();
		$mpagos=$this->tpago_model->mostrarTotal();
		$productos=$this->producto_model->mostrarLimite(array("estado"=>1));
		$nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"tcomprobante"=>"99"));
		$this->layout->setTitle("Nota de Venta");
		$this->layout->view("nventai",compact("establecimientos","nestablecimiento","empresa","canexos","mpagos","nserie","productos"));
	}

	public function guardar($id=NULL)
	{
		if ($this->input->post())
		{
			$impresion='';
			$empresa=$this->empresa_model->mostrar();
			if ($this->input->post('idproducto',true)==null) {
				$mensaje='No envio productos en la venta!';
			} else {
				$pagado=array_sum($this->input->post('monto',true));
				if (valor_check($this->input->post('pcredito',true))==0 && $pagado!=$this->input->post('totalg',true)) {
					$mensaje='El monto cobrado es diferente al comprobante';
				}else{
					$numero=$this->nventa_model->maximo($this->input->post('serie',true));
					$ninicio= $numero==null ? '' : $numero->numero;
					$numeracion=$ninicio+1;

					$consulta=$this->nventa_model->contador(array("serie"=>$this->input->post("serie",true),"numero"=>$numeracion));
					if ($consulta==0) {
						$data=array
						(
							'idestablecimiento'	=>$this->session->userdata("predeterminado"),
							'iduser'						=>$this->session->userdata('id'),
							'femision'					=>date("Y-m-d"),
							'hemision'					=>date('H:i:s'),
							'fvencimiento'			=>date("Y-m-d"),
							'serie'							=>$this->input->post('serie',true),
							'numero'						=>$numeracion,
							'formato'						=>valor_check($this->input->post('formato',true)),
							'idcliente'					=>$this->input->post('idcliente',true),
							'cliente'						=>$this->input->post('cliente',true),
							'total'							=>$this->input->post('totalg',true),
							'izipay'						=>valor_fecha($this->input->post('mizipay',true)),
							'lote'							=>valor_check($this->input->post('impresion',true)),
							'condicion'					=>1,
							'cancelado'					=>1,
						);

						if ($this->input->post('mdsctog',true)!='') {
				      $data["dscto"]=$this->input->post("mdsctog",true);
				    }
						$insertar=$this->nventa_model->insert($data);

						if (valor_check($this->input->post('pcredito',true))==1) {
							$suma=tiempoCuota($this->input->post('pcuota',true));
							$posterior=SumarFecha($suma,date("Y-m-d"));

							$datac=array
							(
								'condicion'		=>2,
								'cancelado'		=>0,
								'pcuota'			=>$this->input->post('pcuota',true),
								'cuotas'			=>$this->input->post('cuotas',true),
								'mcuota'			=>$this->input->post('mcuota',true),
								'fpago'				=>$posterior,
								'fvencimiento'=>$this->input->post('fvencimiento',true),
							);
							$actualizac=$this->nventa_model->update($datac,$insertar);
						} else {
							for ($i=0; $i < count($this->input->post('mpago',true)) ; $i++) {
				        $datap=array
				        (
				        	'idestablecimiento'	=>$this->session->userdata("predeterminado"),
				          'iduser'    				=>$this->session->userdata('id'),
				          'idnventa'  				=>$insertar,
				          'femision'  				=>date("Y-m-d"),
				          'total'   					=>$this->input->post('monto',true)[$i],
				          'idtpago'   				=>$this->input->post('mpago',true)[$i],
				        );
				        $insertarp=$this->cobro_model->insert($datap);
				      }
						}

	  				$punto_acumulado=0;
				    for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
				    	if ($this->input->post('tipo',true)[$i]=='B') {
					      $saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i]);
					      $inicalf=$saldos==null ? 0: $saldos->saldof;
					      $inicalv=$saldos==null ? 0: $saldos->saldov;
					      //costos promedio
					      $costo=$inicalf==0 ? 0 : round($inicalv/$inicalf,4);
					      $salidav=$this->input->post("almacenc",true)[$i]*$costo;

					      $saldof=$inicalf-$this->input->post("almacenc",true)[$i];
					      $saldov=$inicalv-$salidav;
					      $datak=array
					      (
					      	"idestablecimiento"	=>$this->session->userdata("predeterminado"),
					      	"iduser"						=>$this->session->userdata('id'),
					        "fecha"     				=>date("Y-m-d"),
					        "idtmovimiento" 		=>1,
					        "concepto"    			=>"Nota de venta",
					        "idproducto"  			=>$this->input->post("idproducto",true)[$i],
					        "descripcion" 			=>trim($this->input->post("descripcion",true)[$i]),
					        "salidaf"   				=>$this->input->post("almacenc",true)[$i],
					        "saldof"    				=>$saldof,
					        "costo"     				=>$costo,
					        "salidav"   				=>$salidav,
					        "saldov"    				=>$saldov,
					        "documento"   			=>$this->input->post("serie",true)."-".$numeracion,
					      );
					      $insertark=$this->kardex_model->insert($datak);

					      $datas=array('stock'=>$saldof);
					      $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i]));

					      $nlotes="";
					      $clotes="";
					      $flotes="";
					      if ($this->input->post("lote",true)[$i]==1) {
					        $cantidad=$this->input->post("almacenc",true)[$i];
					        $clotes=array();
					        $flotes=array();
					      	$nlotes=array();
					      	if ($this->input->post("nlote",true)[$i]!='') {
					      		$nlotes=explode(",",$this->input->post("nlote",true)[$i]);
										for ($l=0; $l < count($nlotes) ; $l++) {
											$consultal=$this->lote_model->mostrar(array("idestablecimiento"	=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$nlotes[$l]));
											$ncantidad=$cantidad-$consultal->stock;	//nueva cantidad
											$saldoc=$consultal->stock-$cantidad;	//saldo a guardar

											if ($saldoc>0) {
												$datal=array('stock'=>$saldoc);
												$actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$nlotes[$l]);
											} else {
												$elimnarl=$this->lote_model->delete(array("idestablecimiento"	=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$nlotes[$l]));
											}

											if ($consultal->stock<$cantidad) {
												$inicialf=$consultal->stock;
											} else {
												$inicialf=$cantidad;
											}

											array_push($clotes,$inicialf);
											array_push($flotes,$consultal->fvencimiento);
											$cantidad=$ncantidad;
										}
					      	} else {
						        for ($l=0; $l < 3 ; $l++) {
						          $consultal=$this->lote_model->ultimo($this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i]);

						          if ($cantidad>=$consultal->stock) {
						            $elimnarl=$this->lote_model->delete(array("idestablecimiento"	=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$consultal->nlote));
						            $inicialf=$consultal->stock;
						          } else {
						            $datal=array('stock'=>$consultal->stock-$cantidad);
						            $actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$consultal->nlote);
						            $inicialf=$cantidad;
						          }

						          array_push($nlotes,$consultal->nlote);
						          array_push($clotes,$inicialf);
						          array_push($flotes,$consultal->fvencimiento);

						          $cantidad-=$consultal->stock;
						          if ($cantidad<=0) {
						            break;
						          }
						        }
					      	}

					        $nlotes=implode('|', $nlotes);
					        $clotes=implode('|', $clotes);
					        $flotes=implode('|', $flotes);
					      }
					    }

				      $datad=array
				      (
				        'idnventa'    =>$insertar,
				        'idproducto'  =>$this->input->post("idproducto",true)[$i],
				        'descripcion' =>trim($this->input->post('descripcion',true)[$i]),
				        'cantidad'    =>$this->input->post("cantidad",true)[$i],
				        'unidad'      =>$this->input->post("unidad",true)[$i],
				        'precio'      =>$this->input->post("precio",true)[$i],
				        'importe'     =>$this->input->post("importe",true)[$i],
				      );

							if ($this->input->post('tipo',true)[$i]=='B') {
								$datad["calmacen"]		=$this->input->post("almacenc",true)[$i];
								$datad["palmacen"]		=$costo;
								$datad["lote"]				=$nlotes;
								$datad["clote"]				=$clotes;
								$datad["fvencimiento"]=$flotes;
							}

							if ($this->input->post('dscto',true)[$i]>0) {
								if ($this->input->post('tdscto',true)[$i]==0) { //descuento porcentaje
									$mimporte=$this->input->post('cantidad',true)[$i]*$this->input->post('precio',true)[$i];
									$mdscto=$mimporte*$this->input->post('dscto',true)[$i]/100;
								} else { //descuento en monto
									$mdscto=$this->input->post("dscto",true)[$i];
								}
								$datad["dscto"]=$mdscto;
							}
				      //var_dump($datad);
				      $insertard=$this->nventad_model->insert($datad);

				      $producto=$this->producto_model->mostrar(array("p.id"=>$this->input->post("idproducto",true)[$i]));
				      $vpuntos=$this->punto_model->mostrar();
				      $punto_acumulado += $producto->puntos==0 ? 0 : intval($this->input->post("importe",true)[$i]/$vpuntos->valorp);
				    }

						if ($punto_acumulado>0 && $this->input->post("idcliente",true)>1 && $this->input->post("tdocumento",true)!=6) {
							$datap=array
							(
								"idnventa"		=>$insertar,
								"idcliente"	=>$this->input->post("idcliente",true),
								"femision"	=>date("Y-m-d"),
								"inicial"		=>$punto_acumulado,
								"cantidad"	=>$punto_acumulado,
							);
							$insertarp=$this->clientep_model->insert($datap);
						}

						if ($this->input->post('mdsctog',true)!='' && $this->input->post('nvale',true)!='') {
							$idvale=explode("&",$this->input->post("nvale",true));
							$datal=array(
								"estado"=>0,
				        "fcanje"=>date("Y-m-d"),
				      );
							$actualizarl=$this->vale_model->update($datal,$idvale[0]);
						}

				    if ($id!=NULL) {
							$datat=array(
		            "estado"  =>2,
		            "emitido" =>$this->input->post('serie',true).'-'.$numeracion,
		          );
							$actualizar=$this->cotizacion_model->update($datat,array("id"=>$id));
				    }

						if (valor_check($this->input->post('formato',true))==1) {
							$impresion=base_url()."nventa/pdfa4/".$insertar;
						}else{
							$impresion=base_url()."nventa/pdf".$empresa->ticket."/".$insertar;
						}

						$mensaje='Se genero la nota de venta exitosamente!';
					} else {
						$mensaje='El comprobante ya existe';
					}
				}
			}

			$datos['mensaje']=$mensaje;
			$datos['impresion']=$impresion;
			$datos['url']=base_url().'nventa/nventai';
			echo json_encode($datos);
			exit();
		}
	}

	public function nventaa($id)
	{
		$datos=$this->nventa_model->mostrar($id);
		if ($datos->nulo==0) {
			$detalles=$this->nventad_model->mostrarTotal($id);
			foreach ($detalles as $detalle) {
				$productos=$this->producto_model->mostrar(array("p.id"=>$detalle->idproducto));

				if ($productos->tipo=='B') {
					$saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
					$inicalf=$saldos==null ? 0: $saldos->saldof;
					$inicalv=$saldos==null ? 0: $saldos->saldov;

					//costos promedio
					$salidav=$detalle->calmacen*$detalle->palmacen;

					$saldof=$inicalf+$detalle->calmacen;
					$saldov=$inicalv+$salidav;
					$datak=array
					(
						"idestablecimiento"	=>$datos->idestablecimiento,
						"iduser"						=>$this->session->userdata('id'),
						"fecha"							=>date("Y-m-d"),
						"idtmovimiento"			=>1,
						"concepto"					=>"Anulacion Nota de venta",
						"idproducto"				=>$detalle->idproducto,
						"descripcion"				=>$detalle->descripcion,
						"entradaf"					=>$detalle->calmacen,
						"saldof"						=>$saldof,
						"costo"							=>$detalle->palmacen,
						"entradav"					=>$salidav,
						"saldov"						=>$saldov,
						"documento"					=>$datos->serie."-".$datos->numero,
					);
					//var_dump($datak);
					$insertark=$this->kardex_model->insert($datak);

					$datas=array("stock"=>$saldof);
					$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

					//devolucion de lotes
					if ($detalle->lote!='') {
						$nlote=explode("|",$detalle->lote);
						$flote=explode("|",$detalle->fvencimiento);
						$clote=explode("|",$detalle->clote);

						for ($l=0; $l < count($nlote) ; $l++) {
							$consultal=$this->lote_model->mostrar(array("idestablecimiento"	=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlote[$l]));
							if ($consultal==null) {
								$datal=array
								(
									"idestablecimiento"	=>$datos->idestablecimiento,
									"idproducto"				=>$detalle->idproducto,
									"nlote"							=>$nlote[$l],
									"fvencimiento"			=>valor_fecha($flote[$l]),
									"inicial"						=>$clote[$l],
									"stock"							=>$clote[$l],
								);
								$insertarl=$this->lote_model->insert($datal);
							} else {
								$datal=array("stock"=>$consultal->stock+$clote[$l]);
								$actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$nlote[$l]);
							}
						}
					}
				}
			}

			$data=array
			(
				"nulo"	 	=>1,
				"cliente"	=>"(Anulado)".$datos->cliente,
				"total"	=>"0.00",
				"izipay"	=>NULL,
			);
			$actualiza=$this->nventa_model->update($data,$id);

			$datac=array
			(
				"nulo"	 	=>1,
				"total"	=>"0.00",
			);
			$actualizac=$this->cobro_model->update($datac,array("idnventa"=>$id));

			$elimnarp=$this->clientep_model->delete(array("idnventa"=>$id));

			$datat=array("estado"	=>1,"emitido"	=>NULL);
      $actualizar=$this->cotizacion_model->update($datat,array("emitido"=>$datos->serie.'-'.$datos->numero));
			echo "borrado";
		}else{
			echo "no borrado";
		}
	}

	public function consulta($id)
	{
		$datos=$this->nventa_model->mostrar($id);
		$detalles=$this->nventad_model->mostrarTotal($id);
		$this->layout->setLayout("blanco");
		$this->layout->view("consulta",compact("datos","detalles"));
	}

	public function opciones($id)
	{
		$this->layout->setLayout("blanco");
		$this->layout->view("opciones",compact("id"));
	}

	public function pdfa4($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nventa_model->mostrar($id);
		$detalles=$this->nventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa4",compact("empresa","nestablecimiento","datos","detalles","nombre"));
	}

	public function pdf80($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nventa_model->mostrar($id);
		$detalles=$this->nventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$tpuntos=$this->clientep_model->cantidadTotal($datos->idcliente);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf80",compact("empresa","nestablecimiento","datos","detalles","nombre","tpuntos"));
	}

	public function pdf58($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nventa_model->mostrar($id);
		$detalles=$this->nventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$tpuntos=$this->clientep_model->cantidadTotal($datos->idcliente);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf58",compact("empresa","nestablecimiento","datos","detalles","nombre","tpuntos"));
	}

	public function pdfa5($id)
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nventa_model->mostrar($id);
		$detalles=$this->nventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa5",compact("empresa","nestablecimiento","datos","detalles","nombre"));
	}

	public function metodos()
	{
		$datos=$this->tpago_model->mostrarTotal();
		echo json_encode($datos);
	}




}
