<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Pagar extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("tpago_model");
    $this->load->model("compra_model");
    $this->load->model("pago_model");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"cancelado"=>0);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,"cancelado"=>0);}
    $listas=$this->compra_model->mostrarTotal($filtros);
    $this->layout->setTitle("Cuentas por pagar");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas"));
  }

  public function pagari($id)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->input->post())
    {
      if ($this->input->post('importe',true)>$this->input->post('saldo',true)) {
        $this->session->set_flashdata("css", "danger");
        $this->session->set_flashdata("mensaje", "El monto es mucho mayor al que tiene que pagar");
      } else {
        $data=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          "iduser"            =>$this->session->userdata('id'),
          "idcompra"          =>$id,
          "femision"          =>date("Y-m-d"),
          "total"             =>$this->input->post("importe",true),
          "idtpago"           =>$this->input->post("mpago",true),
          "documento"         =>$this->input->post("documento",true),
        );
        $insertar=$this->pago_model->insert($data);

        $pagos=$this->pago_model->montoTotal(array("nulo"=>0,"idcompra"=>$id));
        $saldo=$this->input->post("saldo",true)-$pagos->importe;
        if ($saldo==0) {
          $datac=array("cancelado"=>1);
          $actualizar=$this->compra_model->update($datac,$id);
        }

        $this->session->set_flashdata("css", "success");
        $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
      }
      redirect(base_url()."pagar");
    }

    $datos=$this->compra_model->mostrar($id);
    $pagos=$this->pago_model->mostrarTotal(array("p.nulo"=>0,"p.idcompra"=>$id));
    $mpagos=$this->tpago_model->mostrarTotal();
    $this->layout->setTitle("Cuentas por pagar");
    $this->layout->view("pagari",compact("establecimientos","nestablecimiento","datos","pagos","mpagos"));
  }



}
