<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Producto extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("tafectacion_model");
		$this->load->model("categoria_model");
		$this->load->model("laboratorio_model");
		$this->load->model("pactivo_model");
		$this->load->model("aterapeutica_model");
		$this->load->model("ubicacion_model");
		$this->load->model("kardex_model");
		$this->load->model("lote_model");
    $this->load->model("bonificado_model");
		$this->load->model("compra_model");
		$this->load->model("comprad_model");
		$this->load->model("nventa_model");
		$this->load->model("nventad_model");
		$this->load->model("venta_model");
		$this->load->model("ventad_model");
		$this->load->model("punto_model");
		$this->load->library("mytcpdf");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$listas=$this->producto_model->mostrarLimite(array("tipo"=>'B',"estado"=>1));
		$detalles=$this->producto_model->mostrarTotal(array("tipo"=>'B',"estado"=>1));
		$canexos=$this->establecimiento_model->contador();
		$this->layout->setLayout("contraido");
		$this->layout->setTitle("Producto Activo");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","empresa","listas","detalles","canexos"));
	}

	public function inactivos()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$listas=$this->producto_model->mostrarLimite(array("tipo"=>'B',"estado"=>0));
		$detalles=$this->producto_model->mostrarTotal(array("tipo"=>'B',"estado"=>0));
		$canexos=$this->establecimiento_model->contador();
		$this->layout->setLayout("contraido");
		$this->layout->setTitle("Producto Inactivo");
		$this->layout->view("inactivos",compact("establecimientos","nestablecimiento","empresa","listas","detalles","canexos"));
	}

	public function deficit()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$datos=$this->empresa_model->mostrar();
		$listas=$this->producto_model->mostrarTotal(array("tipo"=>'B',"estado"=>1,"lote"=>1));
		$this->layout->setTitle("Producto Activo");
		$this->layout->view("deficit",compact("establecimientos","nestablecimiento","datos","listas"));
	}

	public function productoi($id=null)
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();

		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array
				(
					'idcategoria'		=>$this->input->post('categoria',true),
					'descripcion'		=>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')),
					'idlaboratorio'	=>$this->input->post('laboratorio',true),
					'idpactivo'			=>$this->input->post('pactivo',true),
					'idaterapeutica'=>$this->input->post('aterapeutica',true),
					'cdigemid'			=>$this->input->post('cdigemid',true),
					'codbarra'			=>$this->input->post('codbarra',true),
					'rsanitario'		=>$this->input->post('rsanitario',true),
					'mstock'				=>$this->input->post('mstock',true),
					'tafectacion'		=>$this->input->post('tafectacion',true),
					'pcompra'				=>$this->input->post('pcompra',true),
					'factor'				=>$this->input->post('factor',true),
					'compra'				=>$this->input->post('compra',true),
					'vsujeta'				=>$this->input->post('vsujeta',true),
					'puntos'				=>$this->input->post('puntos',true),
					'informacion'		=>$this->input->post('informacion',true),
					'idubicacion'		=>$this->input->post('ubicacion',true),
				);
				if ($this->input->post('factor',true)>1) {
					$data['factorb']=$this->input->post('factorb',true);
				}
				if ($this->input->post('stock',true)==0)
				{
					$data['lote']=valor_check($this->input->post('lote',true));
				}
				if ($empresa->pestablecimiento==0) {
					$data['pventa']=$this->input->post('pventa',true);
					$data['venta']=$this->input->post('venta',true);
					$data['pblister']=$this->input->post('pblister',true);
				}
				$guardar=$this->producto_model->update($data,$id);

				if ($empresa->pestablecimiento==1) {
					$datas=array
					(
						'venta'			=>$this->input->post('venta',true),
						'pventa'		=>$this->input->post('pventa',true),
						'pblister'	=>$this->input->post('pblister',true),
					);
					$actualizarp=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$id));
				}

				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			} else {
				$consulta=$this->producto_model->contador(array("descripcion"=>$this->input->post('descripcion',true),"idlaboratorio"=>$this->input->post('laboratorio',true)));
				if ($consulta==0 && $this->input->post('descripcion',true)!='') {
					$data=array
					(
						'tipo'					=>'B',
						'idcategoria'		=>$this->input->post('categoria',true),
						'descripcion'		=>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')),
						'idlaboratorio'	=>$this->input->post('laboratorio',true),
						'idpactivo'			=>$this->input->post('pactivo',true),
						'idaterapeutica'=>$this->input->post('aterapeutica',true),
						'cdigemid'			=>$this->input->post('cdigemid',true),
						'codbarra'			=>$this->input->post('codbarra',true),
						'rsanitario'		=>$this->input->post('rsanitario',true),
						'mstock'				=>$this->input->post('mstock',true),
						'tafectacion'		=>$this->input->post('tafectacion',true),
						'pcompra'				=>$this->input->post('pcompra',true),
						'factor'				=>$this->input->post('factor',true),
						'compra'				=>$this->input->post('compra',true),
						'vsujeta'				=>$this->input->post('vsujeta',true),
						'puntos'				=>$this->input->post('puntos',true),
						'estado'				=>1,
						'lote'					=>valor_check($this->input->post('lote',true)),
						'informacion'		=>$this->input->post('informacion',true),
						'idubicacion'		=>$this->input->post('ubicacion',true),
					);
					if ($this->input->post('factor',true)>1) {
						$data['factorb']=$this->input->post('factorb',true);
					}
					if ($empresa->pestablecimiento==0) {
						$data['pventa']=$this->input->post('pventa',true);
						$data['venta']=$this->input->post('venta',true);
						$data['pblister']=$this->input->post('pblister',true);
					}
					$insertar=$this->producto_model->insert($data);

					$investablecimientos=$this->establecimiento_model->mostrarTotal();
					foreach ($investablecimientos as $investablecimiento) {
						$datae=array
						(
							'idestablecimiento'	=>$investablecimiento->id,
							'idproducto'				=>$insertar,
							'stock'							=>0,
						);
						if ($empresa->pestablecimiento==1) {
							$datae['pventa']=$this->input->post('pventa',true);
							$datae['venta']=$this->input->post('venta',true);
							$datae['pblister']=$this->input->post('pblister',true);
						}
						$insertark=$this->inventario_model->insert($datae);
					}

					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');

					redirect(base_url()."producto/productoi/".$insertar);
				} else {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', 'El producto ya EXISTE!!!!!!');
				}
			}

			$nombreCompleto= $id==null ? 'P_'.$insertar.'.jpg': 'P_'.$id.'.jpg';
			$nro=$id==null ? $insertar: $id;
			if (isset($_FILES['foto']) && $_FILES['foto']['tmp_name']!='') {
        $config['upload_path']   = './downloads/productos/';
        $config['overwrite'] = TRUE;
        $config['allowed_types'] = 'jpg|jpeg';
        $config['max_size']      = 1000;
        $config['max_width']     = 0;
        $config['max_height']    = 0;
        $config['file_name']     = $nombreCompleto;
        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('foto')) {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', $this->upload->display_errors());
		    } else {
					$ruta= addslashes(base_url()."downloads/productos/".$nombreCompleto);
		      $data=array('ruta'=>$ruta);
					$guardar=$this->producto_model->update($data,$nro);
					$imagen=$this->upload->data();
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Se subio con exito la portada '.$imagen["file_name"]);
		    }
			}

			if ($this->input->post('codbarra',true)!='') {
				barcode("./downloads/codigos/".$this->input->post('codbarra',true).'.png', $this->input->post('codbarra',true));
			}
		}

		$datos=$id!=null?$this->producto_model->mostrar(array("p.id"=>$id)):(object) array("idcategoria"=>'',"descripcion"=>'',"idlaboratorio"=>'',"idpactivo"=>'',"idaterapeutica"=>'',"codbarra"=>'',"cdigemid"=>'',"mstock"=>0,"tafectacion"=>10,"compra"=>'', "venta"=>'',"factor"=>1,"pcompra"=>'', "pventa"=>'',"factorb"=>'', "pblister"=>'',"rsanitario"=>'',"vsujeta"=>'',"puntos"=>'', "lote"=>'',"informacion"=>'',"idubicacion"=>'');
		$cantidades=$id!=null?$this->inventario_model->cantidadTotal(array("idproducto"=>$id)):(object) array("stock"=>0);
		$cantidad=$id!=null?$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$id):(object) array("venta"=>'', "pventa"=>'', "pblister"=>'');
		$categorias=$this->categoria_model->mostrarTotal();
		$laboratorios=$this->laboratorio_model->mostrarTotal();
		$pactivos=$this->pactivo_model->mostrarTotal();
		$aterapeuticas=$this->aterapeutica_model->mostrarTotal();
		$tafectaciones=$this->tafectacion_model->mostrarTotal();
		$ubicaciones=$this->ubicacion_model->mostrarTotal();
		$puntos=$this->punto_model->mostrar();
		$this->layout->setTitle("Producto");
		$this->layout->view("productoi",compact("establecimientos","nestablecimiento","empresa","datos","cantidades","laboratorios","categorias","pactivos","aterapeuticas","ubicaciones","id","tafectaciones","puntos","cantidad"));
	}

	public function precios()
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			if(isset($_FILES['archivo']['name']) && in_array($_FILES['archivo']['type'], $file_mimes)) {
				$arr_file = explode('.', $_FILES['archivo']['name']);
				$extension = end($arr_file);
				if('csv' == $extension){
					$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
				} else {
					$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
				}
				$spreadsheet = $reader->load($_FILES['archivo']['tmp_name']);
				// $sheetData = $spreadsheet->getActiveSheet()->toArray();
				// echo "<pre>";
				// print_r($sheetData);

				$sheet_data = $spreadsheet->getActiveSheet()->toArray();
				//$lista 			= [];
				foreach($sheet_data as $key => $val) {
					if($key != 0) {
						$data=array('codbarra'=>$val[2],);
						if ($empresa->pestablecimiento==0) {
							$data['venta']=$val[4];
							$data['pventa']=$val[5];
							$data['pblister']=$val[6];
						}
						$guardar=$this->producto_model->update($data,$val[0]);

						if ($empresa->pestablecimiento==1) {
							$datas=array
							(
								'venta'			=>$val[4],
								'pventa'		=>$val[5],
								'pblister'	=>$val[6],
							);
							$actualizarp=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$val[0]));
						}
					}
				}

				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los precios se han actualizado exitosamente!');
			}else {
				$this->session->set_flashdata('css', 'danger');
				$this->session->set_flashdata('mensaje', 'No existe archivo o no corresponde el tipo!');
			}

			echo base_url()."producto";
			exit();
		}

		$this->layout->setLayout("blanco");
		$this->layout->view("precios");
	}

	public function preciosexcel()
	{
		$empresa=$this->empresa_model->mostrar();
    $listas=$this->producto_model->mostrarTotal(array("estado"=>1));

		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setTitle("Precios");

		$styleArray = [
		    'borders' => [
		        'top' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'bottom' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'left' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'right' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		    ],
		];

		foreach(range("A","G") as $columnID) {
		    $sheet->getColumnDimension($columnID)->setAutoSize(true);
		    $sheet->getStyle($columnID."1")->applyFromArray($styleArray);
		}

		$sheet->setCellValueByColumnAndRow(1, 1,"Id");
		$sheet->setCellValueByColumnAndRow(2, 1,"Nombre");
		$sheet->setCellValueByColumnAndRow(3, 1,"Codigo Barra");
		$sheet->setCellValueByColumnAndRow(4, 1,"Factor");
		$sheet->setCellValueByColumnAndRow(5, 1,"Precio Caja");
		$sheet->setCellValueByColumnAndRow(6, 1,"Precio Unidad");
		$sheet->setCellValueByColumnAndRow(7, 1,"Precio Blister");

		$i=2;
		foreach ($listas as $lista) {
			$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$lista->id);
			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);
			$sheet->getStyle("F".$i)->applyFromArray($styleArray);
			$sheet->getStyle("G".$i)->applyFromArray($styleArray);

			$sheet->setCellValue("A".$i,$lista->id);
			$sheet->setCellValue("B".$i,$lista->descripcion.' '.$lista->nlaboratorio);
			$sheet->setCellValue("C".$i,$lista->codbarra);
			$sheet->setCellValue("D".$i,$lista->factor);
			$sheet->setCellValue("E".$i,$empresa->pestablecimiento==1 ? $cantidad->pventa: $lista->venta);
			$sheet->setCellValue("F".$i,$empresa->pestablecimiento==1 ? $cantidad->pventa: $lista->pventa);
			$sheet->setCellValue("G".$i,$empresa->pestablecimiento==1 ? $cantidad->pventa: $lista->pblister);

			$i++;
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="LISTA_PRECIOS.xlsx"');
    $writer->save('php://output');	// download file
	}

	public function establecimiento($id)
	{
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		$listas=$this->inventario_model->mostrarTotal($id);
		$this->layout->setLayout("blanco");
		$this->layout->view("establecimiento",compact('datos',"listas","empresa"));
	}

	public function inventario($id)
	{
		if ($this->input->post())
		{
			$datak=array
      (
        'idestablecimiento' =>$this->session->userdata("predeterminado"),
        'iduser'            =>$this->session->userdata('id'),
        'fecha'             =>date("Y-m-d"),
        'idtmovimiento'     =>16,
        'concepto'          =>'Stock Actualizado',
        'idproducto'        =>$id,
        'descripcion'       =>trim($this->input->post('descripcion',true)),
        'entradaf'          =>$this->input->post('cantidad',true),
        'saldof'            =>$this->input->post('cantidad',true),
        'costo'             =>$this->input->post('precio',true),
        'entradav'          =>$this->input->post('cantidad',true)*$this->input->post('precio',true),
        'saldov'            =>$this->input->post('cantidad',true)*$this->input->post('precio',true),
      );
      $insertark=$this->kardex_model->insert($datak);

      $eliminar=$this->lote_model->delete(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$id));
      if ($this->input->post('lote',true)!="" && $this->input->post('cantidad',true)>0) {
        $datal=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          'idproducto'        =>$id,
          'nlote'             =>$this->input->post('lote',true),
          'fvencimiento'      =>valor_fecha($this->input->post('fvencimiento',true)),
          'inicial'           =>$this->input->post('cantidad',true),
          'stock'             =>$this->input->post('cantidad',true),
        );
        $insertarl=$this->lote_model->insert($datal);
      }

      //actualizar stock
      $datas=array('stock'=>$this->input->post('cantidad',true));
      $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$id));

      $this->session->set_flashdata('css', 'success');
      $this->session->set_flashdata('mensaje', 'El inventario se actualizo exitosamentei!');

			echo base_url()."producto";
			exit();
		}

		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("inventario",compact('datos'));
	}

	public function lotes($id)
	{
		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		$listas=$this->lote_model->mostrarTotal($this->session->userdata("predeterminado"),$id);
		$this->layout->setLayout("blanco");
		$this->layout->view("lotes",compact('datos',"listas"));
	}

	public function buscompras($id)
	{
		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		$listas=$this->compra_model->ultimas($this->session->userdata("predeterminado"),$id);
		$this->layout->setLayout("blanco");
		$this->layout->view("bcompras",compact('datos',"listas","id"));
	}

	public function habilitar($id)
	{
		if (!$id) {show_404();}
		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		if ($datos==NULL) {show_404();}

		$data=array('estado'=>1);
		$guardar=$this->producto_model->update($data,$id);
		$this->session->set_flashdata('css', 'success');
		$this->session->set_flashdata('mensaje', 'El producto fue habilitado!');
		redirect(base_url()."producto");
	}

	public function deshabilitar($id)
	{
		if (!$id) {show_404();}
		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		if ($datos==NULL) {show_404();}

		$contador=$this->inventario_model->cantidadTotal(array("idproducto"=>$id));
		if ($contador->stock>0) {
			$this->session->set_flashdata('css', 'danger');
			$this->session->set_flashdata('mensaje', 'El producto tiene stock en alguno establecimiento!');
		} else {
			$data=array('estado'=>0);
			$guardar=$this->producto_model->update($data,$id);
			$this->session->set_flashdata('css', 'success');
			$this->session->set_flashdata('mensaje', 'El producto fue deshabilitado!');
		}
		redirect(base_url()."producto");
	}

	public function busListado() //listado general de productos
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			if (strlen($this->input->post('id',true))>2) {
				$productos=$this->producto_model->buscador($this->input->post('id',true),array("tipo"=>'B',"estado"=>$this->input->post('estado',true)));
			}else {
				$productos=$this->producto_model->mostrarLimite(array("tipo"=>'B',"estado"=>$this->input->post('estado',true)));
			}

			$datos=array();
			foreach ($productos as $producto) {
				$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
				$canexos=$this->establecimiento_model->contador();
				$detalle['id']=$producto->id;
				$detalle['descripcion']=$producto->descripcion;
				$detalle['lote']=$producto->lote;
				$detalle['compra']=$producto->compra;
				$detalle['venta']=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;
				$detalle['factor']=$producto->factor;
				$detalle['pcompra']=$producto->pcompra;
				$detalle['pventa']=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
				$detalle['factorb']=$producto->factorb;
				$detalle['pblister']=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
				$detalle['nlaboratorio']=$producto->nlaboratorio;
				$detalle['stock']=$cantidad->stock;
				$detalle['rsanitario']=$producto->rsanitario;
				$detalle['tipo']=$producto->tipo;
				$detalle['estado']=$producto->estado;
				$detalle['canexos']=$canexos;
				array_push($datos,$detalle);
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

/*===========================================================================================================================
=                                                         buscadores                                                        =
===========================================================================================================================*/
	public function busCodigo()
	{
		if ($this->input->post())
		{
			$codigo=$this->producto_model->mostrar(array("codbarra"=>$this->input->post('id',true)));
			if ($codigo==NULL) {
				$datos['success'] = true;
				$datos['data'] = "El codigo de barras esta disponible";
			} else {
				$datos['success'] = false;
				$datos['data'] = "El codigo de barras ya se asigno";
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busProductos() //buscador de productos por nombres
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			if (strlen($this->input->post('id',true))>2) {
				$productos=$this->producto_model->buscador($this->input->post('id',true),array("estado"=>1));
			} else {
				$productos=$this->producto_model->mostrarLimite(array("estado"=>1));
			}

			$datos=array();
			foreach ($productos as $producto) {
				$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
				$bonificacion=$this->bonificado_model->mostrar(array("anuo"=>date("Y"),"mes"=>date("n"),"idproducto"=>$producto->id));
				$valor=$bonificacion==NULL ? 0 : $bonificacion->monto;

				$detalle['id']=$producto->id;
				$detalle['descripcion']=$producto->descripcion;
				$detalle['idlaboratorio']=$producto->idlaboratorio;
				$detalle['lote']=$producto->lote;
				$detalle['compra']=$producto->compra;
				$detalle['venta']=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;
				$detalle['factor']=$producto->factor;
				$detalle['pcompra']=$producto->pcompra;
				$detalle['pventa']=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
				$detalle['factorb']=$producto->factorb;
				$detalle['pblister']=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
				$detalle['nlaboratorio']=$producto->nlaboratorio;
				$detalle['stock']=$cantidad->stock;
				$detalle['tafectacion']=$producto->tafectacion;
				$detalle['bonificacion']=$valor;
				$detalle['tipo']=$producto->tipo;
				$detalle['vsujeta']=$producto->vsujeta;
				$detalle['puntos']=$producto->puntos;
				$detalle['descuento']=$empresa->dscto;
				$detalle['edicion']=$empresa->pventa;
				array_push($datos,$detalle);
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busCodigobarra()
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			$producto=$this->producto_model->mostrar(array("codbarra"=>$this->input->post('id',true),"estado"=>1));
      if ($producto!=null) {
				$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
				$bonificacion=$this->bonificado_model->mostrar(array("anuo"=>date("Y"),"mes"=>date("n"),"idproducto"=>$producto->id));
				$valor=$bonificacion==NULL ? 0 : $bonificacion->monto;

        $datos['id']=$producto->id;
				$datos['descripcion']=$producto->descripcion;
				$datos['idlaboratorio']=$producto->idlaboratorio;
				$datos['lote']=$producto->lote;
				$datos['compra']=$producto->compra;
				$datos['venta']=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;
				$datos['factor']=$producto->factor;
				$datos['pcompra']=$producto->pcompra;
				$datos['pventa']=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
				$datos['factorb']=$producto->factorb;
				$datos['pblister']=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
				$datos['nlaboratorio']=$producto->nlaboratorio;
				$datos['stock']=$cantidad->stock;
				$datos['tafectacion']=$producto->tafectacion;
				$datos['bonificacion']=$valor;
				$datos['tipo']=$producto->tipo;
				$datos['vsujeta']=$producto->vsujeta;
				$datos['puntos']=$producto->puntos;
				$datos['descuento']=$empresa->dscto;
				$datos['edicion']=$empresa->pventa;
      }else{
      	$datos=null;
      }
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busPrincipio()
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			$mostrar=$this->producto_model->mostrar(array("p.id"=>$this->input->post('id',true)));
			$datos=array();
			if ($mostrar->idpactivo>0) {
				$productos=$this->producto_model->mostrarTotal(array("idpactivo"=>$mostrar->idpactivo,"estado"=>1));
				foreach ($productos as $producto) {
					$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
					$detalle['id']=$producto->id;
					$detalle['descripcion']=$producto->descripcion;
					$detalle['idlaboratorio']=$producto->idlaboratorio;
					$detalle['lote']=$producto->lote;
					$detalle['compra']=$producto->compra;
					$detalle['venta']=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;
					$detalle['factor']=$producto->factor;
					$detalle['pcompra']=$producto->pcompra;
					$detalle['pventa']=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
					$detalle['factorb']=$producto->factorb;
					$detalle['pblister']=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
					$detalle['nlaboratorio']=$producto->nlaboratorio;
					$detalle['stock']=$cantidad->stock;
					$detalle['tipo']=$producto->tipo;
					$detalle['vsujeta']=$producto->vsujeta;
					$detalle['puntos']=$producto->puntos;
					$detalle['descuento']=$empresa->dscto;
					$detalle['edicion']=$empresa->pventa;
					array_push($datos,$detalle);
				}
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busTerapeutico()
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			$mostrar=$this->producto_model->mostrar(array("p.id"=>$this->input->post('id',true)));
			$datos=array();
			if ($mostrar->idaterapeutica>0) {
				$productos=$this->producto_model->mostrarTotal(array("idaterapeutica"=>$mostrar->idaterapeutica,"estado"=>1));
				foreach ($productos as $producto) {
					$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
					$detalle['id']=$producto->id;
					$detalle['descripcion']=$producto->descripcion;
					$detalle['idlaboratorio']=$producto->idlaboratorio;
					$detalle['lote']=$producto->lote;
					$detalle['compra']=$producto->compra;
					$detalle['venta']=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;
					$detalle['factor']=$producto->factor;
					$detalle['pcompra']=$producto->pcompra;
					$detalle['pventa']=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
					$detalle['factorb']=$producto->factorb;
					$detalle['pblister']=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
					$detalle['nlaboratorio']=$producto->nlaboratorio;
					$detalle['stock']=$cantidad->stock;
					$detalle['tipo']=$producto->tipo;
					$detalle['vsujeta']=$producto->vsujeta;
					$detalle['puntos']=$producto->puntos;
					$detalle['descuento']=$empresa->dscto;
					$detalle['edicion']=$empresa->pventa;
					array_push($datos,$detalle);
				}
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busLotes()
	{
		if ($this->input->post())
		{
			$datos=$this->lote_model->mostrarTotal($this->session->userdata("predeterminado"),$this->input->post('id',true));
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busPrecios()
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			if ($empresa->pestablecimiento==1) {
				$datos=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$this->input->post('id',true));
			} else {
				$datos=$this->producto_model->mostrar(array("p.id"=>$this->input->post('id',true)));
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function busInformacion()
	{
		$datos=$this->producto_model->mostrar(array("p.id"=>$this->input->post('id',true)));
		$pactivo=$this->pactivo_model->mostrar($datos->idpactivo);
		$aterapeutica=$this->aterapeutica_model->mostrar($datos->idaterapeutica);
		$ubicacion=$this->ubicacion_model->mostrar($datos->idubicacion);
		$this->layout->setLayout("blanco");
		$this->layout->view("binformacion",compact('datos',"pactivo","aterapeutica","ubicacion"));
	}

	public function busEstablecimiento()
	{
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->producto_model->mostrar(array("p.id"=>$this->input->post('id',true)));
		$listas=$this->inventario_model->mostrarTotal($this->input->post('id',true));
		$this->layout->setLayout("blanco");
		$this->layout->view("establecimiento",compact('datos',"listas","empresa"));
	}

/*===========================================================================================================================
=                                                        correcciones                                                       =
===========================================================================================================================*/
	public function kardex($id)
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$datos=$this->producto_model->mostrar(array("p.id"=>$id));
		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$id);
		$listas=$this->kardex_model->mostrarTotal($filtros);
		$this->layout->setTitle("Kardex");
		$this->layout->view("kardex",compact("establecimientos","nestablecimiento","datos","listas","id"));
	}

	public function kardexe($nro,$id)
	{
		if ($this->input->post("valor",true))
		{
			$data=array
			(
				"entradaf"		=>valor_fecha($this->input->post("entradaf",true)),
				"salidaf"			=>valor_fecha($this->input->post("salidaf",true)),
				"saldof"			=>$this->input->post("saldof",true),
				"costo"				=>$this->input->post("costo",true),
				"entradav"		=>valor_fecha($this->input->post("entradav",true)),
				"salidav"			=>valor_fecha($this->input->post("salidav",true)),
				"saldov"			=>$this->input->post("saldov",true),
			);

			$guardar=$this->kardex_model->update($data,$id);
			$this->session->set_flashdata('css', 'success');
			$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			echo base_url()."producto/kardex/".$nro;
			exit();
		}

		$datos=$this->kardex_model->mostrar($id);
		$this->layout->setLayout("blanco");
		$this->layout->view("kardexe",compact("datos"));
	}







}
