<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proveedor extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("departamento_model");
		$this->load->model("provincia_model");
		$this->load->model("distrito_model");
		$this->load->model("proveedor_model");
		$this->load->model("compra_model");
		$this->load->model("gasto_model");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$listas=$this->proveedor_model->mostrarTotal();
		$this->layout->setTitle("Proveedor");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","listas"));
	}

	public function proveedori($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array
				(
					"tdocumento"	=>$this->input->post("tipo",true),
					"documento"		=>$this->input->post("documento",true),
					"nombres"		=>trim(mb_strtoupper($this->input->post('nombres',true), 'UTF-8')),
					"iddepartamento"	=>$this->input->post("departamento",true),
					"idprovincia"		=>$this->input->post("provincia",true),
					"iddistrito"		=>$this->input->post("distrito",true),
					"direccion"		=>$this->input->post("direccion",true),
					"telefono"		=>$this->input->post("telefono",true),
					"email"			=>$this->input->post("email",true),
				);

				$guardar=$this->proveedor_model->update($data,$id);
				$this->session->set_flashdata("css", "success");
				$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
			} else {
				$consulta=$this->proveedor_model->contador($this->input->post("dni",true));
				if ($consulta==0) {
					$data=array
					(
						"tdocumento"	=>$this->input->post("tipo",true),
						"documento"		=>$this->input->post("documento",true),
						"nombres"		=>trim(mb_strtoupper($this->input->post('nombres',true), 'UTF-8')),
						"iddepartamento"	=>$this->input->post("departamento",true),
						"idprovincia"		=>$this->input->post("provincia",true),
						"iddistrito"		=>$this->input->post("distrito",true),
						"direccion"		=>$this->input->post("direccion",true),
						"telefono"		=>$this->input->post("telefono",true),
						"email"			=>$this->input->post("email",true),
					);

					$insertar=$this->proveedor_model->insert($data);
					$this->session->set_flashdata("css", "success");
					$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
				} else {
					$this->session->set_flashdata("css", "danger");
					$this->session->set_flashdata("mensaje", "El proveedor ya EXISTE!!!!!!");
				}
			}
			echo base_url()."proveedor";
			exit();
		}

		$datos=$id!=null?$this->proveedor_model->mostrar(array("p.id"=>$id)):(object) array("tdocumento"=>"", "nombres"=>"", "documento"=>"", "iddepartamento"=>"", "idprovincia"=>"", "iddistrito"=>"", "direccion"=>"", "telefono"=>"", "email"=>"");
		$departamentos=$this->departamento_model->mostrarTotal();
		$provincias=$id!=null?$this->provincia_model->mostrarTotal($datos->iddepartamento):null;
		$distritos=$id!=null?$this->distrito_model->mostrarTotal($datos->idprovincia):null;
		$this->layout->setLayout("blanco");
		$this->layout->view("proveedori",compact("datos","departamentos","provincias","distritos"));
	}

	public function proveedord($id)
	{
		if (!$id) {show_404();}
		$datos=$this->proveedor_model->mostrar(array("p.id"=>$id));
		if ($datos==NULL) {show_404();}

		$contadorn=$this->compra_model->contador(array('idproveedor'=>$id));
		$contadorg=$this->gasto_model->contador('idproveedor',$id);
		$contador=$contadorn+$contadorg;
		if ($contador>0) {
			echo 'no borrado';
		}else{
			$eliminar=$this->proveedor_model->delete($id);
			echo 'borrado';
		}
	}


}
