<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Reporte extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("mes_model");
		$this->load->model("categoria_model");
		$this->load->model("laboratorio_model");
		$this->load->model("pactivo_model");
		$this->load->model("aterapeutica_model");
		$this->load->model("ubicacion_model");
		$this->load->model("tmovimiento_model");
		$this->load->model("lote_model");
		$this->load->model("kardex_model");
		$this->load->model("proveedor_model");
		$this->load->model("compra_model");
		$this->load->model("comprad_model");
		$this->load->model("pago_model");
		$this->load->model("cliente_model");
		$this->load->model("nventa_model");
		$this->load->model("nventad_model");
		$this->load->model("cobro_model");
		$this->load->model("venta_model");
		$this->load->model("ventad_model");
		$this->load->model("cobroe_model");
		$this->load->model("nota_model");
		$this->load->model("notad_model");
		$this->load->model("cobron_model");
		$this->load->model("resumen_model");
		$this->load->model("ingreso_model");
		$this->load->model("gasto_model");
		$this->load->model("tpago_model");
		$this->load->library("mytcpdf");
	}

  public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$categorias=$this->categoria_model->mostrarTotal();
		$salidas=$this->tmovimiento_model->mostrarTotal(array("tipo"=>"S","estado"=>1));
		$ingresos=$this->tmovimiento_model->mostrarTotal(array("tipo"=>"I","estado"=>1));
		$this->layout->setTitle("Reporte Producto");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","categorias","salidas","ingresos"));
	}

  public function busFiltros()
	{
		if ($this->input->post())
		{
			$buscar=$this->input->post('id',true);
			if ($buscar=='Lab') {
				//lista de laboratorios
				$datos=$this->laboratorio_model->mostrarTotal();
			}elseif ($buscar=='Cat') {
				//lista de laboratorios
				$datos=$this->categoria_model->mostrarTotal();
			}elseif ($buscar=='Pac') {
				//lista de principio activo
				$datos=$this->pactivo_model->mostrarTotal();
			}elseif ($buscar=='Ate') {
				//lista de accion terapeutica
				$datos=$this->aterapeutica_model->mostrarTotal();
			}elseif ($buscar=='Ubi') {
				//lista de ubicacion
				$datos=$this->ubicacion_model->mostrarTotal();
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function pdfminimo()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->inventario_model->productosMinimo(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"estado"=>1,"mstock>"=>0,"(stock-mstock)<"=>1));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfminimo",compact("empresa","nestablecimiento","datos"));
	}

	public function pdfstock()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->producto_model->mostrarTotal(array("tipo"=>'B',"estado"=>1));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfstock",compact("empresa","nestablecimiento","datos"));
	}

	public function excelstock()
	{
		$empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$datos=$this->producto_model->mostrarTotal(array("tipo"=>'B',"estado"=>1));
		$spreadsheet = IOFactory::load("./downloads/excel/productosc.xlsx");

		$i = 5;
		foreach ($datos as $dato) {
			$cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$dato->id);
    	$pventa=$empresa->pestablecimiento==1 ? $cantidad->pventa: $dato->pventa;

			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A'.$i,  $dato->id)
					->setCellValue('B'.$i,  $dato->descripcion)
					->setCellValue('C'.$i,  $dato->nlaboratorio)
					->setCellValue('D'.$i,  $cantidad->stock)
					->setCellValue('E'.$i,  $pventa)
					->setCellValue('F'.$i,  $dato->pcompra);
			$i++;
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="STOCK_PRODUCTOS_'.$nestablecimiento->descripcion.'.xlsx"');
    $writer->save('php://output');	// download file
	}

    public function exceldigemid()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->producto_model->productosDgmi();

		$spreadsheet = IOFactory::load("./downloads/excel/formato.xlsx");
		$i = 2;
		foreach ($datos as $dato) {
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A'.$i,  $nestablecimiento->cdigemid)
					->setCellValue('B'.$i,  $dato->cdigemid)
					->setCellValue('C'.$i,  $dato->venta)
					->setCellValue('D'.$i,  $dato->pventa);
			$i++;
		}

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="PRECIOS_DIGEMID_'.$nestablecimiento->descripcion.'.xlsx"');
		header('Cache-Control: max-age=0');
		$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
		$writer->save('php://output');
	}

	public function pdfpstock()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->inventario_model->productosStock($this->session->userdata("predeterminado"));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfpstock",compact("empresa","nestablecimiento","datos"));
	}

	public function excelpstock()
	{
		$empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$datos=$this->inventario_model->productosStock($this->session->userdata("predeterminado"));
		$spreadsheet = IOFactory::load("./downloads/excel/productosl.xlsx");

		$i = 5;
		foreach ($datos as $dato) {
	    $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$dato->id);
	    $pventa=$empresa->pestablecimiento==1 ? $cantidad->pventa: $dato->pventa;

			$lotes=$this->lote_model->mostrarTotal($this->session->userdata("predeterminado"),$dato->id);
			if ($lotes==null) {
				$spreadsheet->setActiveSheetIndex(0)
							->setCellValue('A'.$i,  $dato->id)
							->setCellValue('B'.$i,  $dato->descripcion)
							->setCellValue('C'.$i,  $dato->nlaboratorio)
							->setCellValue('D'.$i,  '')
							->setCellValue('E'.$i,  '')
							->setCellValue('F'.$i,  '')
							->setCellValue('G'.$i,  $cantidad->stock)
							->setCellValue('H'.$i,  $pventa);
				$i++;
			}else{
				$nl=0;
				foreach ($lotes as $lote) {
					if ($nl==0) {
						$spreadsheet->setActiveSheetIndex(0)
								->setCellValue('A'.$i,  $dato->id)
								->setCellValue('B'.$i,  $dato->descripcion)
								->setCellValue('C'.$i,  $dato->nlaboratorio)
								->setCellValue('D'.$i,  $lote->stock)
								->setCellValue('E'.$i,  $lote->nlote)
								->setCellValue('F'.$i,  $lote->fvencimiento)
								->setCellValue('G'.$i,  $cantidad->stock)
								->setCellValue('H'.$i,  $pventa);
					} else {
						$spreadsheet->setActiveSheetIndex(0)
								->setCellValue('A'.$i,  '')
								->setCellValue('B'.$i,  '')
								->setCellValue('C'.$i,  '')
								->setCellValue('D'.$i,  $lote->stock)
								->setCellValue('E'.$i,  $lote->nlote)
								->setCellValue('F'.$i,  $lote->fvencimiento)
								->setCellValue('G'.$i,  '')
								->setCellValue('H'.$i,  '');
					}
					$nl++;
					$i++;
				}
			}
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="STOCK_LOTES_'.$nestablecimiento->descripcion.'.xlsx"');
    $writer->save('php://output');	// download file
	}

	public function pdfcinventario()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->producto_model->mostrarTotal(array("estado"=>1));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfcinventario",compact("empresa","nestablecimiento","datos"));
	}

	public function pdfatributos()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		if ($this->input->post('buscar',true)=='Lab') {
			$buscador='Laboratorio';
			$nombres=$this->laboratorio_model->mostrar($this->input->post('nombres',true));
			$datos=$this->producto_model->mostrarTotal(array("idlaboratorio"=>$this->input->post('nombres',true)));
		} elseif ($this->input->post('buscar',true)=='Cat') {
			$buscador='Categoria';
			$nombres=$this->categoria_model->mostrar($this->input->post('nombres',true));
			$datos=$this->producto_model->mostrarTotal(array("idcategoria"=>$this->input->post('nombres',true)));
		} elseif ($this->input->post('buscar',true)=='Pac') {
			$buscador='Principio Activo';
			$nombres=$this->pactivo_model->mostrar($this->input->post('nombres',true));
			$datos=$this->producto_model->mostrarTotal(array("idpactivo"=>$this->input->post('nombres',true)));
		} elseif ($this->input->post('buscar',true)=='Ate') {
			$buscador='Accion Terapeutica';
			$nombres=$this->aterapeutica_model->mostrar($this->input->post('nombres',true));
			$datos=$this->producto_model->mostrarTotal(array("idaterapeutica"=>$this->input->post('nombres',true)));
		} elseif ($this->input->post('buscar',true)=='Ubi') {
			$buscador='Ubicacion';
			$nombres=$this->ubicacion_model->mostrar($this->input->post('nombres',true));
			$datos=$this->producto_model->mostrarTotal(array("idubicacion"=>$this->input->post('nombres',true)));
		}
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfatributos",compact("empresa","nestablecimiento","datos","buscador","nombres"));
	}

	public function pdfingreso()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$mtraslado=explode('-',$this->input->post('motivoi',true));
		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idtmovimiento"=>$mtraslado[0],"fecha>="=>$this->input->post('iinicio',true),"fecha<="=>$this->input->post('ifin',true));
		$datos=$this->kardex_model->mostrarTotal($filtros);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfingreso",compact("empresa","nestablecimiento","datos","mtraslado"));
	}

	public function pdfsalida()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$mtraslado=explode('-',$this->input->post('motivos',true));
		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idtmovimiento"=>$mtraslado[0],"fecha>="=>$this->input->post('sinicio',true),"fecha<="=>$this->input->post('sfin',true));
		$datos=$this->kardex_model->mostrarTotal($filtros);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfsalida",compact("empresa","nestablecimiento","datos","mtraslado"));
	}

	public function pdfvencido()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->lote_model->productosVencer(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"fvencimiento<="=>SumarFecha($this->input->post('fvencer',true)),"estado"=>1,"stock>"=>0));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfvencido",compact("empresa","nestablecimiento","datos","fecha"));
	}

	public function excelvencido()
	{
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$listas=$this->lote_model->productosVencer(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"fvencimiento<="=>SumarFecha($this->input->post('fvencer',true)),"estado"=>1,"stock>"=>0));

		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setTitle("Precios");

		$styleArray = [
		    'borders' => [
		        'top' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'bottom' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'left' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'right' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		    ],
		];

		foreach(range("A","E") as $columnID) {
		    $sheet->getColumnDimension($columnID)->setAutoSize(true);
		    $sheet->getStyle($columnID."1")->applyFromArray($styleArray);
		}

		$sheet->setCellValueByColumnAndRow(1, 1,"Id");
		$sheet->setCellValueByColumnAndRow(2, 1,"Descripcion");
		$sheet->setCellValueByColumnAndRow(3, 1,"Lote");
		$sheet->setCellValueByColumnAndRow(4, 1,"F. Vcto");
		$sheet->setCellValueByColumnAndRow(5, 1,"Cantidad");

		$i=2; $j=1;
		foreach ($listas as $lista) {
			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);

			$nproducto=$lista->descripcion;
    	if ($lista->nlaboratorio!='') {$nproducto.=' ['.$lista->nlaboratorio.']';}

			$sheet->setCellValue("A".$i,$j);
			$sheet->setCellValue("B".$i,$nproducto);
			$sheet->setCellValue("C".$i,$lista->lote);
			$sheet->setCellValue("D".$i,$lista->fvencimiento);
			$sheet->setCellValue("E".$i,$lista->stock);

			$i++; $j++;
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="PRODUCTOS_VENCIDOS_'.$nestablecimiento->descripcion.'.xlsx"');
    $writer->save('php://output');	// download file
	}

	public function compras()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$this->layout->setTitle("Reporte Compra");
		$this->layout->view("compras",compact("establecimientos","nestablecimiento"));
	}

	public function pdfcompra()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
    if ($this->session->userdata("tipo")=='admin') {
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true));
		} else {
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true));
		}
		$datos=$this->compra_model->mostrarTotal($filtros);
		$detallado=valor_check($this->input->post('detallado',true));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfcompra",compact("empresa","nestablecimiento","datos","detallado"));
  }

	public function pdfproductoc()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->compra_model->cproducto($this->session->userdata("predeterminado"),$this->input->post('finicio',true),$this->input->post('ffin',true),$this->input->post('idproducto',true));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfproductoc",compact("empresa","nestablecimiento","datos"));
  }

  public function pdfproveedor()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
  	$empresa=$this->empresa_model->mostrar();
  	$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('pinicio',true),"femision<="=>$this->input->post('pfin',true),"idproveedor"=>$this->input->post('idproveedor',true));
  	$datos=$this->compra_model->mostrarTotal($filtros);
  	$detallado=valor_check($this->input->post('detalladop',true));
  	$this->layout->setLayout("blanco");
  	$this->layout->view("pdfproveedor",compact("empresa","nestablecimiento","datos","detallado"));
  }

	public function caja()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$usuarios=$this->usuario_model->activos();
		$this->layout->setTitle("Reporte Caja");
		$this->layout->view("caja",compact("establecimientos","nestablecimiento","usuarios"));
	}

	public function pdfmedios()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
    $mpagos=$this->tpago_model->mostrarTotal();
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfmedios",compact("empresa","nestablecimiento","mpagos"));
  }

	public function pdfmediosu()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
    $mpagos=$this->tpago_model->mostrarTotal();
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfmediosu",compact("empresa","nestablecimiento","mpagos"));
  }

  public function ventas()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$usuarios=$this->usuario_model->activos();
		$this->layout->setTitle("Reporte Ventas");
		$this->layout->view("ventas",compact("establecimientos","nestablecimiento","empresa","usuarios"));
	}

	public function pdfventa()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		if ($this->session->userdata("tipo")=='admin') {
			if ($this->input->post('cusuario',true)=='') {
				$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true));
			}else{
				$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"iduser"=>$this->input->post('cusuario',true),"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true));
			}
		} else {
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true));
		}
		$datos=$this->venta_model->mostrarTotal($filtros,"asc");
		$notas=$this->nota_model->mostrarTotal($filtros,"asc");
		$detallado=valor_check($this->input->post('detallado',true));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfventa",compact("empresa","nestablecimiento","datos","notas","detallado"));
  }

  public function pdfnota()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
  	$empresa=$this->empresa_model->mostrar();
  	if ($this->session->userdata("tipo")=='admin') {
  		if ($this->input->post('nusuario',true)=='') {
  			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('ninicio',true),"femision<="=>$this->input->post('nfin',true));
  		}else{
  			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"iduser"=>$this->input->post('nusuario',true),"femision>="=>$this->input->post('ninicio',true),"femision<="=>$this->input->post('nfin',true));
  		}
  	} else {
  		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$this->input->post('ninicio',true),"femision<="=>$this->input->post('nfin',true));
  	}
  	$datos=$this->nventa_model->mostrarTotal($filtros,"asc");
  	$detallado=valor_check($this->input->post('detalladon',true));
  	$this->layout->setLayout("blanco");
  	$this->layout->view("pdfnota",compact("empresa","nestablecimiento","datos","detallado"));
  }

	public function pdfproductov()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		if ($this->session->userdata("tipo")=='admin') {
	  	if ($this->input->post('nusuario',true)=='') {
	  		$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$this->input->post('finicio',true),"femision<="=>$this->input->post('ffin',true),"idproducto"=>$this->input->post('idproducto',true));
	  	}else{
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"iduser"=>$this->input->post('nusuario',true),"femision>="=>$this->input->post('finicio',true),"femision<="=>$this->input->post('ffin',true),"idproducto"=>$this->input->post('idproducto',true));
	  	}
		} else {
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"iduser"=>$this->session->userdata("id"),"femision>="=>$this->input->post('finicio',true),"femision<="=>$this->input->post('ffin',true),"idproducto"=>$this->input->post('idproducto',true));
		}

		$nventas=$this->nventa_model->vproducto($filtros);
		$ventas=$this->venta_model->vproducto($filtros);
		$notas=$this->nota_model->vproducto($filtros);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfproductov",compact("empresa","nestablecimiento","nventas","ventas","notas"));
  }

  public function pdfcliente()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
  	$empresa=$this->empresa_model->mostrar();
  	$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$this->input->post('pinicio',true),"femision<="=>$this->input->post('pfin',true),"idcliente"=>$this->input->post('idcliente',true));

  	$comprobantes=$this->venta_model->mostrarTotal($filtros,"asc");
  	$notas=$this->nota_model->mostrarTotal($filtros,"asc");
  	$datos=$this->nventa_model->mostrarTotal($filtros,"asc");
  	$detallado=valor_check($this->input->post('detalladop',true));
  	$this->layout->setLayout("blanco");
  	$this->layout->view("pdfcliente",compact("empresa","nestablecimiento","datos","notas","comprobantes","detallado"));
  }

  public function pdfproducto()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nventa_model->ganancia(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('vinicio',true),"femision<="=>$this->input->post('vfin',true),"nulo"=>0));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfproducto",compact("empresa","nestablecimiento","datos"));
  }

	public function excelventa()
	{
		$empresa=$this->empresa_model->mostrar();
		if ($this->session->userdata("tipo")=='admin') {
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('vinicio',true),"femision<="=>$this->input->post('vfin',true));
		}else{
			$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$this->input->post('vinicio',true),"femision<="=>$this->input->post('vfin',true),"iduser"=>$this->session->userdata("id"));
		}
		$ventas=$this->venta_model->mostrarTotal($filtros,"asc");
		$notas=$this->nota_model->mostrarTotal($filtros,"asc");
  	$nventas=$this->nventa_model->mostrarTotal($filtros,"asc");

		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setTitle("Ventas");

		$styleArray = [
		    'borders' => [
		        'top' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'bottom' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'left' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		        'right' => [
		            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
		        ],
		    ],
		];

		foreach(range("A","K") as $columnID) {
		    $sheet->getColumnDimension($columnID)->setAutoSize(true);
		    $sheet->getStyle($columnID."1")->applyFromArray($styleArray);
		}

		$sheet->setCellValueByColumnAndRow(1, 1,"Id");
		$sheet->setCellValueByColumnAndRow(2, 1,"Fecha");
		$sheet->setCellValueByColumnAndRow(3, 1,"Hora");
		$sheet->setCellValueByColumnAndRow(4, 1,"Tipo");
		$sheet->setCellValueByColumnAndRow(5, 1,"Numero");
		$sheet->setCellValueByColumnAndRow(6, 1,"Cliente");
		$sheet->setCellValueByColumnAndRow(7, 1,"Subtotal");
		$sheet->setCellValueByColumnAndRow(8, 1,"IGV");
		$sheet->setCellValueByColumnAndRow(9, 1,"Total");
		$sheet->setCellValueByColumnAndRow(10, 1,"Izipay");
		$sheet->setCellValueByColumnAndRow(11, 1,"Vendedor");

		$i=2; $j=1;
		foreach ($ventas as $dato) {
			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);
			$sheet->getStyle("F".$i)->applyFromArray($styleArray);
			$sheet->getStyle("G".$i)->applyFromArray($styleArray);
			$sheet->getStyle("H".$i)->applyFromArray($styleArray);
			$sheet->getStyle("I".$i)->applyFromArray($styleArray);
			$sheet->getStyle("J".$i)->applyFromArray($styleArray);
			$sheet->getStyle("K".$i)->applyFromArray($styleArray);

			if ($dato->tipo_estado=='09' || $dato->tipo_estado=='11') {
      	if ($dato->tipo_estado=='09') {$nestado='RECHAZADO';} else {$nestado='ANULADO';}

					$sheet->setCellValue("A".$i,$j);
					$sheet->setCellValue("B".$i,$dato->femision);
					$sheet->setCellValue("C".$i,$dato->hemision);
					$sheet->setCellValue("D".$i,$dato->ncomprobante);
					$sheet->setCellValue("E".$i,$dato->serie.'-'.$dato->numero);
					$sheet->setCellValue("F".$i,$nestado);
					$sheet->setCellValue("G".$i,0);
					$sheet->setCellValue("H".$i,0);
					$sheet->setCellValue("I".$i,0);
					$sheet->setCellValue("H".$i,0);
					$sheet->setCellValue("K".$i,'');
      } else {
          $nombre= $this->usuario_model->mostrar($dato->iduser);
          $nusuario=$nombre->nombres??'';

					$sheet->setCellValue("A".$i,$j);
					$sheet->setCellValue("B".$i,$dato->femision);
					$sheet->setCellValue("C".$i,$dato->hemision);
					$sheet->setCellValue("D".$i,$dato->ncomprobante);
					$sheet->setCellValue("E".$i,$dato->serie.'-'.$dato->numero);
					$sheet->setCellValue("F".$i,$dato->cliente);
					$sheet->setCellValue("G".$i,$dato->subtotal);
					$sheet->setCellValue("H".$i,$dato->tigv);
					$sheet->setCellValue("I".$i,$dato->total);
					$sheet->setCellValue("H".$i,$dato->izipay);
					$sheet->setCellValue("K".$i,$nusuario);
      }
			$i++; $j++;
		}

		foreach ($notas as $dato) {
			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);
			$sheet->getStyle("F".$i)->applyFromArray($styleArray);
			$sheet->getStyle("G".$i)->applyFromArray($styleArray);
			$sheet->getStyle("H".$i)->applyFromArray($styleArray);
			$sheet->getStyle("I".$i)->applyFromArray($styleArray);
			$sheet->getStyle("J".$i)->applyFromArray($styleArray);
			$sheet->getStyle("K".$i)->applyFromArray($styleArray);

			if ($dato->tipo_estado=='09' || $dato->tipo_estado=='11') {
      	if ($dato->tipo_estado=='09') {$nestado='RECHAZADO';} else {$nestado='ANULADO';}

					$sheet->setCellValue("A".$i,$j);
					$sheet->setCellValue("B".$i,$dato->femision);
					$sheet->setCellValue("C".$i,$dato->hemision);
					$sheet->setCellValue("D".$i,$dato->ncomprobante);
					$sheet->setCellValue("E".$i,$dato->serie.'-'.$dato->numero);
					$sheet->setCellValue("F".$i,$nestado);
					$sheet->setCellValue("G".$i,'');
					$sheet->setCellValue("H".$i,'');
					$sheet->setCellValue("I".$i,'');
					$sheet->setCellValue("H".$i,'');
					$sheet->setCellValue("K".$i,'');
      } else {
          $nombre= $this->usuario_model->mostrar($dato->iduser);
          $nusuario=$nombre->nombres??'';

					$sheet->setCellValue("A".$i,$j);
					$sheet->setCellValue("B".$i,$dato->femision);
					$sheet->setCellValue("C".$i,$dato->hemision);
					$sheet->setCellValue("D".$i,$dato->ncomprobante);
					$sheet->setCellValue("E".$i,$dato->serie.'-'.$dato->numero);
					$sheet->setCellValue("F".$i,$dato->cliente);
					$sheet->setCellValue("G".$i,$dato->subtotal*-1);
					$sheet->setCellValue("H".$i,$dato->tigv*-1);
					$sheet->setCellValue("I".$i,$dato->total*-1);
					$sheet->setCellValue("H".$i,'');
					$sheet->setCellValue("K".$i,$nusuario);
      }
			$i++; $j++;
		}

		foreach ($nventas as $dato) {
			$sheet->getStyle("A".$i)->applyFromArray($styleArray);
			$sheet->getStyle("B".$i)->applyFromArray($styleArray);
			$sheet->getStyle("C".$i)->applyFromArray($styleArray);
			$sheet->getStyle("D".$i)->applyFromArray($styleArray);
			$sheet->getStyle("E".$i)->applyFromArray($styleArray);
			$sheet->getStyle("F".$i)->applyFromArray($styleArray);
			$sheet->getStyle("G".$i)->applyFromArray($styleArray);
			$sheet->getStyle("H".$i)->applyFromArray($styleArray);
			$sheet->getStyle("I".$i)->applyFromArray($styleArray);
			$sheet->getStyle("J".$i)->applyFromArray($styleArray);
			$sheet->getStyle("K".$i)->applyFromArray($styleArray);

			$nombre= $this->usuario_model->mostrar($dato->iduser);
      $nusuario=$nombre->nombres??'';

			$sheet->setCellValue("A".$i,$j);
			$sheet->setCellValue("B".$i,$dato->femision);
			$sheet->setCellValue("C".$i,$dato->hemision);
			$sheet->setCellValue("D".$i,'Nota de Venta');
			$sheet->setCellValue("E".$i,$dato->serie.'-'.$dato->numero);
			$sheet->setCellValue("F".$i,$dato->cliente);
			$sheet->setCellValue("G".$i,'');
			$sheet->setCellValue("H".$i,'');
			$sheet->setCellValue("I".$i,$dato->total);
			$sheet->setCellValue("H".$i,$dato->izipay);
			$sheet->setCellValue("K".$i,$nusuario);
			$i++; $j++;
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="LISTA_VENTAS.xlsx"');
    $writer->save('php://output');	// download file
	}

  public function contable()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$anuos=$this->periodo_model->mostrarTotal();
		$meses=$this->mes_model->mostrarTotal();
		$this->layout->setTitle("Registros Contables");
		$this->layout->view("contable",compact("establecimientos","nestablecimiento","anuos","meses"));
	}

	public function cexcel()
	{
		$empresa=$this->empresa_model->mostrar();
		$year=$this->input->post('canuo',true);
		$month=$this->input->post('cmes',true);
		$datos=$this->compra_model->mostrarRegistro(array("nulo"=>0,"year(femision)"=>$year,"month(femision)"=>$month));

		$spreadsheet = IOFactory::load("./downloads/excel/formato81.xlsx");

		$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('B3',  $year.'-'.$month)
					->setCellValue('B4',  $empresa->ruc)
					->setCellValue('E5',  $empresa->nombres);

		$i = 14;
		foreach ($datos as $dato) {
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('B'.$i,  $dato->femision)
					->setCellValue('D'.$i,  $dato->comprobante)
					->setCellValue('E'.$i,  $dato->serie)
					->setCellValue('G'.$i,  $dato->numero)
					->setCellValue('H'.$i,  $dato->tdocumento)
					->setCellValue('I'.$i,  $dato->documento)
					->setCellValue('J'.$i,  $dato->proveedor)
					->setCellValue('T'.$i,  $dato->total);

			if ($dato->porcentaje=='0.18') {
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('K'.$i,  $dato->subtotal)
					->setCellValue('L'.$i,  $dato->igv);
			} else {
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('Q'.$i,  $dato->subtotal);
			}
			$i++;
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="REGISTRO_COMPRAS_'.$year.$month.'.xlsx"');
    $writer->save('php://output');	// download file
	}

	public function vexcel()
	{
		$empresa=$this->empresa_model->mostrar();
		$year=$this->input->post('vanuo',true);
		$month=$this->input->post('vmes',true);
		$datos=$this->venta_model->mostrarRegistro(array("year(femision)"=>$year,"month(femision)"=>$month));
		$notas=$this->nota_model->mostrarRegistro(array("year(femision)"=>$year,"month(femision)"=>$month));

		$spreadsheet = IOFactory::load("./downloads/excel/formato141.xlsx");

		$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('B3',  $year.'-'.$month)
					->setCellValue('B4',  $empresa->ruc)
					->setCellValue('D5',  $empresa->nombres);

		$i = 12;
		foreach ($datos as $dato) {
			if ($dato->tipo_estado=='09' || $dato->tipo_estado=='11') {
        if ($dato->tipo_estado=='09') {$nestado='Rechazado';} else {$nestado='Anulado';}

				$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('B'.$i,  $dato->femision)
					->setCellValue('D'.$i,  $dato->tcomprobante)
					->setCellValue('E'.$i,  $dato->serie)
					->setCellValue('F'.$i,  $dato->numero)
					->setCellValue('G'.$i,  0)
					->setCellValue('H'.$i,  0)
					->setCellValue('I'.$i,  $nestado)
					->setCellValue('K'.$i,  0)
					->setCellValue('O'.$i,  0)
					->setCellValue('Q'.$i,  0);
			}else{
				$spreadsheet->setActiveSheetIndex(0)
						->setCellValue('B'.$i,  $dato->femision)
						->setCellValue('D'.$i,  $dato->tcomprobante)
						->setCellValue('E'.$i,  $dato->serie)
						->setCellValue('F'.$i,  $dato->numero)
						->setCellValue('G'.$i,  $dato->tdocumento)
						->setCellValue('H'.$i,  $dato->documento)
						->setCellValue('I'.$i,  $dato->cliente)
						->setCellValue('K'.$i,  $dato->tgravado)
						->setCellValue('L'.$i,  $dato->texonerado)
						->setCellValue('M'.$i,  $dato->tinafecto)
						->setCellValue('O'.$i,  $dato->tigv)
						->setCellValue('Q'.$i,  $dato->total);
			}
			$i++;
		}

		foreach ($notas as $dato) {
			$ventas=$this->venta_model->mostrar($dato->idventa);
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('B'.$i,  $dato->femision)
					->setCellValue('D'.$i,  $dato->tcomprobante)
					->setCellValue('E'.$i,  $dato->serie)
					->setCellValue('F'.$i,  $dato->numero)
					->setCellValue('G'.$i,  $dato->tdocumento)
					->setCellValue('H'.$i,  $dato->documento)
					->setCellValue('I'.$i,  $dato->cliente)
					->setCellValue('K'.$i,  $dato->tgravado)
					->setCellValue('L'.$i,  $dato->texonerado)
					->setCellValue('M'.$i,  $dato->tinafecto)
					->setCellValue('O'.$i,  $dato->tigv)
					->setCellValue('Q'.$i,  $dato->total)
					->setCellValue('S'.$i,  $ventas->femision)
					->setCellValue('T'.$i,  $ventas->tcomprobante)
					->setCellValue('U'.$i,  $ventas->serie)
					->setCellValue('V'.$i,  $ventas->numero);
			$i++;
		}

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="REGISTRO_VENTAS_'.$year.$month.'.xlsx"');
    $writer->save('php://output');	// download file
	}

	public function directorio()
	{
		$empresa=$this->empresa_model->mostrar();
		$fecha=$empresa->ruc.'-'.$this->input->post('danuo',true).'-'.$this->input->post('dmes',true);
		$this->load->library('zip');

		$facturas=$this->venta_model->mostrarTotal(array("tcomprobante"=>'01'),"asc");
		$notasf=$this->nota_model->mostrarTotal(array("v.tcomprobante"=>'01'),"asc");

		foreach ($facturas as $dato) {
			$nombre=$empresa->ruc.'-'.$dato->tcomprobante.'-'.$dato->serie.'-'.$dato->numero;
			$path = 'C:/laragon/www/apifacturalo/storage/app/tenancy/tenants/tenancy_farmacia/signed/'.$nombre.'.xml';
			$new_path = $fecha.'/factura/'.$nombre.'.xml';
			$this->zip->read_file($path, $new_path);

			$patr = 'C:/laragon/www/apifacturalo/storage/app/tenancy/tenants/tenancy_farmacia/cdr/R-'.$nombre.'.zip';
			$new_patr = $fecha.'/factura/R-'.$nombre.'.zip';
			$this->zip->read_file($patr, $new_patr);
		}

		foreach ($notasf as $dato) {
			$nombre=$empresa->ruc.'-'.$dato->tcomprobante.'-'.$dato->serie.'-'.$dato->numero;
			$path = 'C:/laragon/www/apifacturalo/storage/app/tenancy/tenants/tenancy_farmacia/signed/'.$nombre.'.xml';
			$new_path = $fecha.'/factura/'.$nombre.'.xml';
			$this->zip->read_file($path, $new_path);

			$patr = 'C:/laragon/www/apifacturalo/storage/app/tenancy/tenants/tenancy_farmacia/cdr/R-'.$nombre.'.zip';
			$new_patr = $fecha.'/factura/R-'.$nombre.'.zip';
			$this->zip->read_file($patr, $new_patr);
		}

		$inicio=primer_dia_mes($this->input->post('dmes',true),$this->input->post('danuo',true));
		$fin=ultimo_dia_mes($this->input->post('dmes',true),$this->input->post('danuo',true));
		$resumenes=$this->resumen_model->mostrarTotal(array('fdocumento>='=>$inicio,'fdocumento<='=>$fin,"tproceso"=>1));

		foreach ($resumenes as $dato) {
			$nombre=$empresa->ruc.'-'.$dato->identificador;
			$path = 'C:/laragon/www/apifacturalo/storage/app/tenancy/tenants/tenancy_farmacia/signed/'.$nombre.'.xml';
			$new_path = $fecha.'/boleta/'.$nombre.'.xml';
			$this->zip->read_file($path, $new_path);

			$patr = 'C:/laragon/www/apifacturalo/storage/app/tenancy/tenants/tenancy_farmacia/cdr/R-'.$nombre.'.zip';
			$new_patr = $fecha.'/boleta/R-'.$nombre.'.zip';
			$this->zip->read_file($patr, $new_patr);
		}

		$this->zip->download($fecha.'.zip');
	}






}
