<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Servicio extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("tafectacion_model");
    $this->load->model("categoria_model");
    $this->load->model("punto_model");
    $this->load->model("nventa_model");
    $this->load->model("venta_model");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $listas=$this->producto_model->mostrarLimite(array("tipo"=>'S',"estado"=>1));
    $detalles=$this->producto_model->mostrarTotal(array("tipo"=>'S',"estado"=>1));
    $this->layout->setTitle("Servicio Activo");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","empresa","listas","detalles"));
  }

  public function inactivos()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $listas=$this->producto_model->mostrarLimite(array("tipo"=>'S',"estado"=>0));
    $detalles=$this->producto_model->mostrarTotal(array("tipo"=>'S',"estado"=>0));
    $this->layout->setTitle("Servicio Inactivo");
    $this->layout->view("inactivos",compact("establecimientos","nestablecimiento","empresa","listas","detalles"));
  }

  public function servicioi($id=null)
  {
    $empresa=$this->empresa_model->mostrar();
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array
        (
          'idcategoria'   =>$this->input->post('categoria',true),
          'descripcion'   =>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')),
          'tafectacion'   =>$this->input->post('tafectacion',true),
          'puntos'        =>$this->input->post('puntos',true),
        );
        if ($empresa->pestablecimiento==0) {
          $data['pventa']=$this->input->post('pventa',true);
        }
        $guardar=$this->producto_model->update($data,$id);

        if ($empresa->pestablecimiento==1) {
          $datas=array('pventa'=>$this->input->post('pventa',true));
          $actualizarp=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$id));
        }
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $consulta=$this->producto_model->contador(array("descripcion"=>$this->input->post('descripcion',true)));
        if ($consulta==0) {
          $data=array
          (
            'tipo'          =>'S',
            'idcategoria'   =>$this->input->post('categoria',true),
            'descripcion'   =>trim(mb_strtoupper($this->input->post('descripcion',true), 'UTF-8')),
            'tafectacion'   =>$this->input->post('tafectacion',true),
            'factor'        =>1,
            'puntos'        =>$this->input->post('puntos',true),
            'estado'        =>1,
          );
          if ($empresa->pestablecimiento==0) {
            $data['pventa']=$this->input->post('pventa',true);
          }
          $insertar=$this->producto_model->insert($data);

          $investablecimientos=$this->establecimiento_model->mostrarTotal();
          foreach ($investablecimientos as $investablecimiento) {
            $datae=array
            (
              'idestablecimiento' =>$investablecimiento->id,
              'idproducto'        =>$insertar,
              'stock'             =>0,
            );
            if ($empresa->pestablecimiento==1) {
              $datae['pventa']=$this->input->post('pventa',true);
            }
            $insertark=$this->inventario_model->insert($datae);
          }

          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'El servicio ya EXISTE!!!!!!');
        }
      }
      echo base_url()."servicio";
      exit();
    }

    $datos=$id!=null?$this->producto_model->mostrar(array("p.id"=>$id)):(object) array("idcategoria"=>'',"descripcion"=>'',"tafectacion"=>10,"pventa"=>'',"puntos"=>'');
    $cantidad=$id!=null?$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$id):(object) array("pventa"=>'');
    $categorias=$this->categoria_model->mostrarTotal();
    $tafectaciones=$this->tafectacion_model->mostrarTotal();
    $puntos=$this->punto_model->mostrar();
    $this->layout->setLayout("blanco");
    $this->layout->view("servicioi",compact('empresa','datos','categorias','tafectaciones','puntos','cantidad'));
  }

  public function busventas($id)
  {
    $datos=$this->producto_model->mostrar(array("p.id"=>$id));
    $this->layout->setLayout("blanco");
    $this->layout->view("bventas",compact('datos',"id"));
  }

  public function habilitar($id)
  {
    if (!$id) {show_404();}
    $datos=$this->producto_model->mostrar(array("p.id"=>$id));
    if ($datos==NULL) {show_404();}

    $data=array('estado'=>1);
    $guardar=$this->producto_model->update($data,$id);
    $this->session->set_flashdata('css', 'success');
    $this->session->set_flashdata('mensaje', 'El servicio fue habilitado!');
    redirect(base_url()."servicio");
  }

  public function deshabilitar($id)
  {
    if (!$id) {show_404();}
    $datos=$this->producto_model->mostrar(array("p.id"=>$id));
    if ($datos==NULL) {show_404();}

    $data=array('estado'=>0);
    $guardar=$this->producto_model->update($data,$id);
    $this->session->set_flashdata('css', 'success');
    $this->session->set_flashdata('mensaje', 'El servicio fue deshabilitado!');
    redirect(base_url()."servicio");
  }

  public function busListado() //listado general de productos
  {
    if ($this->input->post())
    {
      if (strlen($this->input->post('id',true))>2) {
        $productos=$this->producto_model->buscador($this->input->post('id',true),array("tipo"=>'S',"estado"=>$this->input->post('estado',true)));
      }else {
        $productos=$this->producto_model->mostrarLimite(array("tipo"=>'S',"estado"=>$this->input->post('estado',true)));
      }

      $datos=array();
      foreach ($productos as $producto) {
        $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
        $detalle['id']=$producto->id;
        $detalle['descripcion']=$producto->descripcion;
        $detalle['lote']=$producto->lote;
        $detalle['compra']=$producto->compra;
        $detalle['venta']=$producto->venta;
        $detalle['factor']=$producto->factor;
        $detalle['pcompra']=$producto->pcompra;
        $detalle['pventa']=$producto->pventa;
        $detalle['pblister']=$producto->pblister;
        $detalle['factorb']=$producto->factorb;
        $detalle['nlaboratorio']=$producto->nlaboratorio;
        $detalle['stock']=$cantidad->stock;
        $detalle['rsanitario']=$producto->rsanitario;
        $detalle['tipo']=$producto->tipo;
        $detalle['estado']=$producto->estado;
        array_push($datos,$detalle);
      }
      echo json_encode($datos);
    }
    else
    {
      show_404();
    }
  }


}
