<?php
defined("BASEPATH") OR exit('No direct script access allowed');

class Solicitud extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("proveedor_model");
		$this->load->model("solicitud_model");
		$this->load->model("solicitudd_model");
		$this->load->library("mytcpdf");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$inicio=$this->input->post("inicio",true)!=null ? $this->input->post("inicio",true) : SumarFecha("-15 day",date("Y-m-d")) ;
		$fin=$this->input->post("fin",true)!=null ? $this->input->post("fin",true) : date("Y-m-d") ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->solicitud_model->mostrarTotal($filtros);
		$this->layout->setLayout("contraido");
		$this->layout->setTitle("Solicitud Compra Producto");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin"));
	}

	public function solicitudi()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		if ($this->input->post())
		{
			if ($this->input->post("idproducto",true)==null) {
				$this->session->set_flashdata("css", "danger");
				$this->session->set_flashdata("mensaje", "No envio productos en la solicitud compra!");
			} else {
				$data=array
				(
					"idestablecimiento"	=>$this->session->userdata("predeterminado"),
					"iduser"						=>$this->session->userdata('id'),
					"femision"					=>$this->input->post("fecha",true),
					"idproveedor"				=>$this->input->post("idproveedor",true),
					"proveedor"					=>$this->input->post("proveedor",true),
					"estado"						=>1,
				);
				$insertar=$this->solicitud_model->insert($data);

				for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
					$datad=array
					(
						"idsolicitud"		=>$insertar,
						"idproducto"		=>$this->input->post("idproducto",true)[$i],
						"descripcion"		=>trim($this->input->post("descripcion",true)[$i]),
						"unidad"				=>$this->input->post("unidad",true)[$i],
						"factor"				=>$this->input->post("factor",true)[$i],
						"cantidad"			=>$this->input->post("cantidad",true)[$i],
					);
					$insertard=$this->solicitudd_model->insert($datad);
				}

				$this->session->set_flashdata("css", "success");
				$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
			}
			redirect(base_url()."solicitud");
		}

		$this->layout->setTitle("Solicitud Compra Producto");
		$this->layout->view("solicitudi",compact("establecimientos","nestablecimiento"));
	}

	public function solicituda($id)
	{
		$datos=$this->solicitud_model->mostrar($id);
		$data=array("estado"=>3);
		$actualiza=$this->solicitud_model->update($data,$id);

		echo "borrado";
	}

	public function pdfsolicitud($id)
  {
		$empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$datos=$this->solicitud_model->mostrar($id);
		$detalles=$this->solicitudd_model->mostrarTotal($id);
		$proveedor=$this->proveedor_model->mostrar(array("p.id"=>$datos->idproveedor));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfsolicitud",compact("empresa","nestablecimiento","datos","detalles","proveedor","id"));
  }


}
