<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuario extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("acceso_model");
		$this->load->model("anivel_model");
	}

	public function index()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		$listas=$this->usuario_model->mostrarTotal();
		$this->layout->setTitle("Usuarios");
		$this->layout->view("index",compact("establecimientos","listas"));
	}

	public function usuariosi($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array
				(
					'nombres'						=>$this->input->post('nombres',true),
					'idestablecimiento'	=>implode(',',$this->input->post('establecimiento',true)),
					'predeterminadoe'		=>$this->input->post('predeterminadoe',true),
					'estado'						=>valor_check($this->input->post('estado',true)),
					'tipo'							=>$this->input->post('tipo',true),
				);

				$guardar=$this->usuario_model->update($data,$id);
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			} else {
				$consulta=$this->usuario_model->contador($this->input->post('usuario',true));
				if ($consulta==0) {
					$data=array
					(
						'nombres'						=>$this->input->post('nombres',true),
						'idestablecimiento'	=>implode(',',$this->input->post('establecimiento',true)),
						'predeterminadoe'		=>$this->input->post('predeterminadoe',true),
						'estado'						=>$this->input->post('estado',true),
						'tipo'							=>$this->input->post('tipo',true),
						'usuario'						=>$this->input->post('usuario',true),
						'clave'							=>$this->input->post('clave',true),
					);

					$insertar=$this->usuario_model->insert($data);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
				} else {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', 'El usuario ya EXISTE!!!!!!');
				}
			}
			echo base_url()."usuario";
			exit();
		}

		$establecimientos=$this->establecimiento_model->mostrarTotal();
		$datos=$id!=null?$this->usuario_model->mostrar($id):(object) array("nombres"=>'', "idestablecimiento"=>1, "predeterminadoe"=>1, "tipo"=>'', "estado"=>1);
		$this->layout->setLayout("blanco");
		$this->layout->view("usuariosi",compact("datos","establecimientos","id"));
	}

	public function usuariosr($id)
	{
		if (!$id) {show_404();}
		$datos=$this->usuario_model->mostrar($id);
		if ($datos==NULL) {show_404();}

		$data=array('clave'=>$datos->usuario);
		$guardar=$this->usuario_model->update($data,$id);
		$this->session->set_flashdata('css', 'success');
		$this->session->set_flashdata('mensaje', 'La contraseña fue restaurada!');

		redirect(base_url()."usuario");
	}

	public function usuariosd($id)
	{
		if (!$id) {show_404();}
		$datos=$this->usuario_model->mostrar($id);
		if ($datos==NULL) {show_404();}

		$eliminar=$this->usuario_model->delete($id);
		echo 'borrado';
	}

	public function usuariosc()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		if ($this->input->post())
		{
			$datos=$this->usuario_model->mostrar($this->session->userdata("id"));
			if ($datos->clave==$this->input->post('anterior',true)) {
				$data=array('clave'=>$this->input->post('posterior',true));

				$guardar=$this->usuario_model->update($data,$this->session->userdata("id"));
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'La contraseña fue cambiada!');
			} else {
				$this->session->set_flashdata('css', 'danger');
				$this->session->set_flashdata('mensaje', 'No se ingreso bien la contraseña actual!');
			}
		}

		$this->layout->setTitle("Usuarios");
		$this->layout->view("usuariosc",compact("establecimientos"));
	}

	public function acceso($id)
	{
		if ($this->input->post())
		{
			$eliminarm=$this->ausuario_model->delete($id);
			for($i = 0; $i < count($this->input->post('menu',true)); $i++) {
				$data=array
				(
					'idacceso'	=>$this->input->post('menu',true)[$i],
					'iduser'	=>$id,
				);
				//var_dump($data); echo "<br>";
				$insertar=$this->ausuario_model->insert($data);
			}

			$eliminars=$this->anusuario_model->delete($id);
			for($i = 0; $i < count($this->input->post('submenu',true)); $i++) {
				$datas=array
				(
					'idacceson'	=>$this->input->post('submenu',true)[$i],
					'iduser'	=>$id,
				);
				//var_dump($datas); echo "<br>";
				$insertars=$this->anusuario_model->insert($datas);
			}

			$this->session->set_flashdata('css', 'success');
			$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			echo base_url()."usuario";
			exit();
		}

		$empresa=$this->empresa_model->mostrar();
		if ($empresa->facturacion==1) {
			$datos=$this->acceso_model->mostrarTotal();
		} else {
			$datos=$this->acceso_model->mostrarLimite();
		}
		$establecimientos=$this->establecimiento_model->contador();
		$this->layout->setLayout("blanco");
		$this->layout->view("acceso",compact('datos','id','empresa','establecimientos'));
	}

	public function establecimiento()
	{
		$data = array('predeterminado'=> $this->input->post('valor',true));
		$this->session->set_userdata($data);

		echo 1;
	}



}
