<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Utilitario extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("tpago_model");
		$this->load->model("tingreso_model");
		$this->load->model("tgasto_model");
		$this->load->model("ingreso_model");
		$this->load->model("gasto_model");
	}

	public function index()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		$periodos=$this->periodo_model->mostrarTotal();
		$mpagos=$this->tpago_model->mostrarTotal();
		$cingresos=$this->tingreso_model->mostrarTotal();
		$cgastos=$this->tgasto_model->mostrarTotal();
		$this->layout->setTitle("Medio Pago");
		$this->layout->view("index",compact("establecimientos","mpagos","periodos","cingresos","cgastos"));
	}

	public function periodoi($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array("descripcion"=>$this->input->post("descripcion",true));
				$guardar=$this->periodo_model->update($data,$id);
				$this->session->set_flashdata("css", "success");
				$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
			} else {
				$consulta=$this->periodo_model->contador($this->input->post("descripcion",true));
				if ($consulta==0) {
					$data=array("descripcion"=>$this->input->post("descripcion",true));
					$insertar=$this->periodo_model->insert($data);
					$this->session->set_flashdata("css", "success");
					$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
				} else {
					$this->session->set_flashdata("css", "danger");
					$this->session->set_flashdata("mensaje", "La periodo ya EXISTE!!!!!!");
				}
			}
			echo base_url()."utilitario";
			exit();
		}

		$datos=$id!=null?$this->periodo_model->mostrar($id):(object) array("descripcion"=>"");
		$this->layout->setLayout("blanco");
		$this->layout->view("utilitarioi",compact("datos"));
	}

	public function mpagoi($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array('descripcion'=>$this->input->post('descripcion',true));
				$guardar=$this->tpago_model->update($data,$id);
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			} else {
				$consulta=$this->tpago_model->contador($this->input->post('descripcion',true));
				if ($consulta==0) {
					$data=array('descripcion'=>$this->input->post('descripcion',true));
					$insertar=$this->tpago_model->insert($data);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
				} else {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', 'El medio pago ya EXISTE!!!!!!');
				}
			}
			echo base_url()."utilitario";
			exit();
		}

		$datos=$id!=null?$this->tpago_model->mostrar($id):(object) array("descripcion"=>'');
		$this->layout->setLayout("blanco");
		$this->layout->view("utilitarioi",compact('datos'));
	}

	public function tingresoi($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array('descripcion'=>$this->input->post('descripcion',true));
				$guardar=$this->tingreso_model->update($data,$id);
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			} else {
				$consulta=$this->tingreso_model->contador($this->input->post('descripcion',true));
				if ($consulta==0) {
					$data=array('descripcion'=>$this->input->post('descripcion',true));
					$insertar=$this->tingreso_model->insert($data);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
				} else {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', 'El medio pago ya EXISTE!!!!!!');
				}
			}
			echo base_url()."utilitario";
			exit();
		}

		$datos=$id!=null?$this->tingreso_model->mostrar($id):(object) array("descripcion"=>'');
		$this->layout->setLayout("blanco");
		$this->layout->view("utilitarioi",compact('datos'));
	}

	public function tingresod($id)
	{
		if (!$id) {show_404();}
		$datos=$this->tingreso_model->mostrar($id);
		if ($datos==NULL) {show_404();}

		$contador=$this->ingreso_model->contador('comprobante',$id);
		if ($contador>0) {
			echo 'no borrado';
		}else{
			$eliminar=$this->tingreso_model->delete($id);
			echo 'borrado';
		}
	}

	public function tgastoi($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array('descripcion'=>$this->input->post('descripcion',true));
				$guardar=$this->tgasto_model->update($data,$id);
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			} else {
				$consulta=$this->tgasto_model->contador($this->input->post('descripcion',true));
				if ($consulta==0) {
					$data=array('descripcion'=>$this->input->post('descripcion',true));
					$insertar=$this->tgasto_model->insert($data);
					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
				} else {
					$this->session->set_flashdata('css', 'danger');
					$this->session->set_flashdata('mensaje', 'El medio pago ya EXISTE!!!!!!');
				}
			}
			echo base_url()."utilitario";
			exit();
		}

		$datos=$id!=null?$this->tgasto_model->mostrar($id):(object) array("descripcion"=>'');
		$this->layout->setLayout("blanco");
		$this->layout->view("utilitarioi",compact('datos'));
	}

	public function tgastod($id)
	{
		if (!$id) {show_404();}
		$datos=$this->tgasto_model->mostrar($id);
		if ($datos==NULL) {show_404();}

		$contador=$this->gasto_model->contador('comprobante',$id);
		if ($contador>0) {
			echo 'no borrado';
		}else{
			$eliminar=$this->tgasto_model->delete($id);
			echo 'borrado';
		}
	}



}
