<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Compra_model extends CI_Model
{
	public $table = "compras";
	public function __construct()
	{
		parent::__construct();
	}

	public function mostrarTotal($filtros)
	{
		$query=$this->db
				->select("v.id, v.iduser, v.nulo, v.comprobante, v.serie, v.numero, v.proveedor, v.idproveedor, v.femision, v.subtotal, v.igv, v.total, v.percepcion, v.condicion, v.cancelado, v.almacen, c.descripcion as ncomprobante")
				->from($this->table." v")
				->join("tipo_comprobantes c","v.comprobante=c.id")
				->where($filtros)//,"nulo"=>0
				->order_by("id","desc")
				->get();
		return $query->result();
	}

	public function mostrar($id)
	{
		$query=$this->db
				->select("v.id, v.idestablecimiento, v.nulo, v.comprobante, v.serie, v.numero, v.proveedor, v.idproveedor, v.femision, v.incluye, v.porcentaje, v.dscto, v.subtotal, v.igv, v.total, v.percepcion, v.condicion, v.cancelado, v.almacen, c.descripcion as ncomprobante")
				->from($this->table." v")
				->join("tipo_comprobantes c","v.comprobante=c.id")
				->where(array("v.id"=>$id))
				->get();
		return $query->row();
	}

	public function insert($data=array())
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($data=array(),$id)
	{
		$this->db->where(array("id"=>$id));
		$this->db->update($this->table, $data);
	}

	public function contador($filtros)
	{
		$this->db->from($this->table)->where($filtros);
		return $this->db->count_all_results();
	}

	public function montoTotal($filtros)
	{
		$query=$this->db
				->select_sum("total")
				->from($this->table)
				->where($filtros)
				->get();
		return $query->row();
	}

	public function cproducto($anexo,$inicio,$fin,$idproducto)
	{
		$query=$this->db
				->select("v.comprobante, v.serie, v.numero, v.proveedor, v.femision, v.porcentaje, v.incluye, c.descripcion as ncomprobante, d.unidad, d.cantidad, d.precio, d.importe, d.lote, d.fvencimiento")
				->from($this->table." v")
				->join("tipo_comprobantes c","v.comprobante=c.id")
				->join("compras_detalle d", "v.id = d.idcompra")
				->where(array("idestablecimiento"=>$anexo,"nulo"=>0,"femision>="=>$inicio,"femision<="=>$fin,"idproducto"=>$idproducto))
				->order_by("femision","desc")
				->get();
		return $query->result();
	}

	public function ultimas($anexo,$idproducto)
	{
		$query=$this->db
				->select("v.serie, v.numero, v.proveedor, v.femision, v.porcentaje, v.incluye, d.unidad, d.cantidad, d.precio, d.importe, d.lote, d.fvencimiento")
				->from($this->table." v")
				->join("compras_detalle d", "v.id = d.idcompra")
				->where(array("idestablecimiento"=>$anexo,"nulo"=>0,"idproducto"=>$idproducto))
				->order_by("femision","desc")
				->limit(20)
				->get();
		return $query->result();
	}

	public function mostrarRegistro($filtros)
	{
		$query=$this->db
				->select("c.femision, c.comprobante, c.serie, c.numero, c.proveedor, c.idproveedor, c.porcentaje, c.incluye, c.subtotal, c.igv, c.total, c.condicion, c.cancelado, p.tdocumento, p.documento")
				->from($this->table." c")
				->join("proveedores p","c.idproveedor=p.id")
				->where($filtros)//,"nulo"=>0
				->order_by("c.id")
				->get();
		return $query->result();
	}

}
