<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventario_model extends CI_Model
{
	public $table = "inventarios";

	public function __construct()
	{
		parent::__construct();
	}

	public function mostrarTotal($idproducto)
	{
		$query=$this->db
				->select("i.id, i.idestablecimiento, i.stock, i.venta, i.pventa, i.pblister, e.descripcion as nestablecimiento")
				->from($this->table." i")
				->join("establecimientos e","i.idestablecimiento=e.id")
				->where(array("idproducto"=>$idproducto))
				->get();
		return $query->result();
	}

	public function mostrar($anexo,$idproducto)
	{
		$query=$this->db
				->select("id, idestablecimiento, idproducto, stock, venta, pventa, pblister")
				->from($this->table)
				->where(array("idestablecimiento"=>$anexo,"idproducto"=>$idproducto))
				->get();
		return $query->row();
	}

	public function insert($data=array())
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($data=array(),$filtros)
	{
		$this->db->where($filtros);
		$this->db->update($this->table, $data);
	}

	public function cantidadTotal($filtros)
	{
		$query=$this->db
				->select_sum("stock")
				->from($this->table)
				->where($filtros)
				->get();
		return $query->row();
	}

	public function productosMinimo($filtros)
	{
		$query=$this->db->select("p.id, p.descripcion, p.mstock, (stock-mstock) as actual, b.descripcion as nlaboratorio, i.stock")
				->from($this->table." i")
				->join("productos p", "p.id = i.idproducto")
				->join("laboratorios b", "b.id = p.idlaboratorio", "left")
				->where($filtros)
				->limit(200)
				->get();
		//echo $this->db->last_query();exit;
		return $query->result();
	}

	public function productosStock($anexo)
	{
		$query=$this->db->select("p.id, p.descripcion, p.pcompra, p.pventa, b.descripcion as nlaboratorio, i.stock")
				->from($this->table." i")
				->join("productos p", "p.id = i.idproducto")
				->join("laboratorios b", "b.id = p.idlaboratorio", "left")
				->where(array("idestablecimiento"=>$anexo,"estado"=>1,"stock>"=>0))
				->get();
		//echo $this->db->last_query();exit;
		return $query->result();
	}


}
