<?php
if ($datos->condicion==1) { $tpago='Contado';} else {$tpago='Credito';}

$pdf = new Mytcpdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetTitle('Comprobante Pago');
$pdf->SetMargins(13,18,13);

$pdf->SetAutoPageBreak(true,9.5);
$pdf->SetAuthor('SisPharma');

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->AddPage();

// contenido
$pdf->SetFont('helvetica', '',9.5);
$tblc = '<table cellspacing="0" cellpadding="0" border="0">
        <tr>
            <td width="25%" align="center"><img src="'.$empresa->logo.'" border="0" height="70"/></td>
            <td width="45%" align="center">'.$empresa->nombres.'<br>'.'RUC '.$empresa->ruc.'<br> <span style="font-size: 0.7 em;">'.$nestablecimiento->direccion.'<br>'.$nestablecimiento->ndepartamento.'-'.$nestablecimiento->nprovincia.'-'.$nestablecimiento->ndistrito.'<br>'.'TELF '.$nestablecimiento->telefono.'</span></td>
            <td width="30%" align="center" style="border: 1px solid #000;"><br><br>'.'RUC Nº '.$empresa->ruc.'<br><b style="font-size: 1.2 em;">'.$datos->ncomprobante.'  Electrónica'.'<br>'.$datos->serie.'-'.zerofill($datos->numero, 8).'</b></td>
        </tr>
        </table>';
$pdf->writeHTML($tblc, false, false, false, false, '');
$pdf->Ln(2);

$style = ['width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => [0, 0, 0]];
$pdf->SetLineStyle($style);
$pdf->Line(13, $pdf->getY(), $pdf->getPageWidth()-13, $pdf->getY());

$pdf->SetFont('helvetica','',9);
$tblf = '<table cellspacing="0" cellpadding="2" border="0">
        <tr>
            <td width="15%"><strong>Señor(es) : </strong></td>
            <td width="45%">'.$clientes->nombres.'</td>
            <td width="25%"><strong>Fecha Emision: </strong></td>
            <td width="15%">'.$datos->femision.'</td>
        </tr>
        <tr>
            <td><strong>'.$clientes->descripcion.' :</strong></td>
            <td>'.$clientes->documento.'</td>
            <td><strong>Fecha Vencimiento :</strong></td>
            <td>'.$datos->fvencimiento.'</td>
        </tr>
        <tr>
            <td><strong>Direccion :</strong></td>
            <td>'.$clientes->direccion.' -- '.$clientes->ndistrito.' - '.$clientes->nprovincia.' - '.$clientes->ndepartamento.'</td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td><strong>Telefono :</strong></td>
            <td>'.$clientes->telefono.'</td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td><strong>Vendedor :</strong></td>
            <td>'.$nombre->nombres.'</td>
            <td><strong>Condiciones Pago :</strong></td>
            <td>'.$tpago.'</td>
        </tr>
        </table>';
$pdf->writeHTML($tblf, false, false, false, false, '');
$pdf->Ln(2);

$pdf->SetFont('helvetica','B',7);
$tbl = '<table cellspacing="0" cellpadding="1" border="0">
        <tr>
            <th align="center" width="8%" style="border: 1px solid #000;"><strong>CANT</strong></th>
            <th align="center" width="8%" style="border: 1px solid #000;"><strong>UNIDAD</strong></th>
            <th align="center" width="52%" style="border: 1px solid #000;"><strong>DESCRIPCION</strong></th>
            <th align="center" width="12%" style="border: 1px solid #000;"><strong>P.UNIT</strong></th>
            <th align="center" width="8%" style="border: 1px solid #000;"><strong>DSCTO</strong></th>
            <th align="center" width="12%" style="border: 1px solid #000;"><strong>TOTAL</strong></th>
        </tr>';
	$gdscto=0;
	$pdf->SetFont('helvetica','',9);
	foreach ($detalles as $detalle) {
        $lotes='';
        if ($detalle->descuentos!='') {
            $descuentos=json_decode($detalle->descuentos);

            $mdscto=$descuentos->monto;
            $gdscto+=floatval($descuentos->monto);
            $ddscto= ' ('.($$descuentos->factor*100).' % Descuento)';
        } else {
            $mdscto='';
            $ddscto='';
        }

		if ($detalle->lote!='') {
			$lotes="<br> Lote : ".$detalle->lote." -- Vcto : ".$detalle->fvencimiento;
		}
        $tbl .= '<tr>
            <td>'.$detalle->cantidad.'</td>
            <td>NIU</td>
            <td>'.$detalle->descripcion.$ddscto.$lotes.'</td>
            <td align="right">'.$detalle->precio.'</td>
            <td align="center">'.$mdscto.'</td>
            <td align="right">'.$detalle->importe.'</td>
        </tr>';
	}
$tbl .= '</table>';

$pdf->writeHTML($tbl, false, false, false, false, '');
$pdf->Ln(1);

$style = ['width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => [0, 0, 0]];
$pdf->SetLineStyle($style);
$pdf->Line(13, $pdf->getY(), $pdf->getPageWidth()-13, $pdf->getY());

$tblt = '<table cellspacing="0" cellpadding="1" border="0">';
    if ($datos->descuentos!='') {
    $descuentos=json_decode($datos->descuentos);
    $tblt .= '<tr>
        <td width="88%" align="right"><strong>DESCUENTO GLOBAL : S/.</strong></td>
        <td width="12%" align="right">'.formatoPrecio($descuentos->monto+($descuentos->monto*0.18)).'</td>
        </tr>';
    }

	if ($datos->tgravado>0) {
    $tblt .= '<tr>
        <td width="88%" align="right"><strong>OP GRAVADAS : S/.</strong></td>
        <td width="12%" align="right">'.$datos->tgravado.'</td>
        </tr>';
    }

    if ($datos->tinafecto>0) {
    $tblt .= '<tr>
        <td width="88%" align="right"><strong>OP INAFECTAS : S/.</strong></td>
        <td width="12%" align="right">'.$datos->tinafecto.'</td>
        </tr>';
    }

    if ($datos->texonerado>0) {
    $tblt .= '<tr>
        <td width="88%" align="right"><strong>OP EXONERADAS : S/.</strong></td>
        <td width="12%" align="right">'.$datos->texonerado.'</td>
        </tr>';
    }
    $tblt .= '<tr>
        <td width="88%" align="right"><strong>IGV : S/.</strong></td>
        <td width="12%" align="right">'.$datos->tigv.'</td>
        </tr>';
	$tblt .= '<tr>
        <td width="88%" align="right"><strong>TOTAL : S/.</strong></td>
        <td width="12%" align="right">'.$datos->total.'</td>
        </tr>';
$tblt .= '</table>';

$pdf->writeHTML($tblt, true, false, false, false, '');

$pdf->SetFont('helvetica','B',8);
$pdf->MultiCell(0,2,'SON : '.MontoMonetarioEnLetras($datos->total),0,'L');
$pdf->Ln(2);

// $pdf->SetFont('helvetica','B',8);
// $pdf->Cell(0,4,'Numeros de Cuenta a Nombre de : '.$empresa->nombres,0,1,'L');
// $pdf->Cell(45,4,'BCP Cta Corriente',0,0,'L');
// $pdf->Cell(45,4,'BCP CCI',0,1,'L');
// $pdf->SetFont('helvetica','',8);
// $pdf->Cell(45,4,'2152631067050',0,0,'L');
// $pdf->Cell(45,4,'00221500263106705025',0,1,'L');
// $pdf->Ln(2);

$qrcode = $empresa->ruc."|".$datos->tcomprobante."|".$datos->serie."|".$datos->numero."|".$datos->tigv."|".$datos->total."|".$datos->femision."|".$clientes->tdocumento."|".$clientes->documento."|".$datos->hash;

$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255)00
    'module_width' => 1, // width of a single module in points
    'module_height' => 1 // height of a single module in points
);
// QRCODE,Q : QR-CODE Better error correction
$pdf->write2DBarcode($qrcode, 'QRCODE,Q', $pdf->GetX()+75,$pdf->GetY(), 35, 35, $style, 'N');

if ($datos->hash!='') {
    $pdf->SetFont('helvetica','',7);
    $pdf->Cell(0,3,'Codigo Hash : '.$datos->hash,0,1,'C');
    $pdf->Ln(2);
}

//$pdf->Output();
$archivo='./downloads/pdf/'.$datos->filename.'.pdf';
//$pdf->Output($archivo,'F');

$pdf_string = $pdf->Output('pseudo.pdf', 'S');
file_put_contents($archivo, $pdf_string);
